/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.list.array.TIntArrayList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.chart.ShapeUtil;
import org.broadinstitute.genee.filter.BetweenFloatFilter;
import org.broadinstitute.genee.filter.CombinedFilter;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.filter.GTE;
import org.broadinstitute.genee.filter.LTE;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.heatmap.DefaultElementPainter;
import org.broadinstitute.genee.heatmap.DefaultHeatMapColorScheme;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeSupplier;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.heatmap.menu.file.StringTableModel;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Comparators;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class MafFileImporter {
    private static final String HOMOZYGOUS_DEL = "Homozygous Del";

    public static Map<String, Object> read(String file) throws IOException {
        String[][] data = ((Array2DContentHandler)new ExcelReader(file, new Array2DContentHandler()).getContentHandler()).getData();
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            String[] row = data[i];
            int ncols = row.length;
            for (int j = 0; j < ncols; ++j) {
                row[j] = IOUtil.stripQuotes(row[j]);
            }
        }
        List<String> header = Arrays.asList(data[0]);
        TIntArrayList additionalColumns = new TIntArrayList();
        int geneSymbolColumn = header.indexOf("Hugo_Symbol");
        if (geneSymbolColumn == -1) {
            throw new IOException("Hugo_Symbol not found");
        }
        int sampleIdColumn = header.indexOf("Tumor_Sample_Barcode");
        if (sampleIdColumn == -1) {
            System.out.println("Using Array_ID");
            sampleIdColumn = header.indexOf("Array_ID");
        }
        if (sampleIdColumn == -1) {
            throw new IOException("Array_ID not found");
        }
        int valueColumn = header.indexOf("cancer_cell_frac");
        if (valueColumn == -1) {
            valueColumn = header.indexOf("i_tumor_f");
        }
        LinkedHashSet<String> sampleIdsSet = new LinkedHashSet<String>();
        LinkedHashSet<String> geneIdsSet = new LinkedHashSet<String>();
        int length2 = data.length;
        for (int i = 1; i < length2; ++i) {
            String[] row = data[i];
            String gene = row[geneSymbolColumn];
            String sample = row[sampleIdColumn];
            sampleIdsSet.add(sample);
            geneIdsSet.add(gene);
        }
        String[] genes = geneIdsSet.toArray(new String[0]);
        String[] samples = sampleIdsSet.toArray(new String[0]);
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(new File(file).getName(), genes.length, samples.length);
        DatasetUtil.fill(dataset, Float.NaN);
        TIntArrayList additionalSeries = new TIntArrayList();
        String homozygousSeries = "homozygousix";
        int homozygousIndex = header.indexOf(homozygousSeries);
        if (homozygousIndex != -1) {
            dataset.addSeries(homozygousSeries, Number.class);
            additionalSeries.add(homozygousIndex);
        } else {
            System.out.println(homozygousSeries + " not found.");
        }
        Vector geneVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "Id", String.class);
        int length3 = geneVector.size();
        for (int i = 0; i < length3; ++i) {
            geneVector.setValue(i, genes[i]);
        }
        Vector sampleVector = MetadataUtil.addRowVector(dataset.getColumnMetadata(), "Id", String.class);
        int length4 = sampleVector.size();
        for (int i = 0; i < length4; ++i) {
            sampleVector.setValue(i, samples[i]);
        }
        ArrayList<Vector> sampleVectors = new ArrayList<Vector>();
        int length5 = additionalColumns.size();
        for (int j = 0; j < length5; ++j) {
            String field = header.get(additionalColumns.getQuick(j));
            sampleVectors.add(MetadataUtil.addColumnVector(dataset.getColumnMetadata(), field, String.class));
        }
        Map sampleToIndex = VectorUtil.createValueToIndexMap(sampleVector);
        Map geneToIndex = VectorUtil.createValueToIndexMap(geneVector);
        int nrows = data.length;
        for (int i = 1; i < nrows; ++i) {
            int j;
            float value;
            String[] row = data[i];
            String gene = row[geneSymbolColumn];
            String sample = row[sampleIdColumn];
            int rowIndex = geneToIndex.get(gene);
            int columnIndex = sampleToIndex.get(sample);
            if (valueColumn != -1) {
                value = ParserHelper.parseFloatNaN(row[valueColumn]);
                if (Float.isNaN(value)) {
                    value = -1.0f;
                }
            } else {
                value = 1.0f;
            }
            dataset.setValue(rowIndex, columnIndex, value);
            int nseries = additionalSeries.size();
            for (j = 0; j < nseries; ++j) {
                dataset.setObjectValue(rowIndex, columnIndex, Float.valueOf(ParserHelper.parseFloat(row[additionalSeries.getQuick(j)])), j + 1);
            }
            int length6 = additionalColumns.size();
            for (j = 0; j < length6; ++j) {
                ((Vector)sampleVectors.get(j)).setValue(columnIndex, row[additionalColumns.getQuick(j)]);
            }
        }
        MetadataUtil.maybeConvertMetadataClass(dataset, true);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataset", dataset);
        map.put("geneToIndex", geneToIndex);
        map.put("valueColumn", valueColumn);
        map.put("homozygousIndex", homozygousIndex);
        return map;
    }

    public static void openMafFile(final String file) {
        new BackgroundTask<ProjectGENEEResultTreeNode>("Import MAF File"){

            @Override
            protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
                Map<String, Object> map = MafFileImporter.read(file);
                File dir = new File(file).getParentFile();
                Dataset _dataset = (Dataset)map.get("dataset");
                Map geneToIndex = (Map)map.get("geneToIndex");
                int valueColumn = (Integer)map.get("valueColumn");
                int homozygousIndex = (Integer)map.get("homozygousIndex");
                String mafFileName = _dataset.getName();
                if (dir.isDirectory()) {
                    RowMajorArray2DDataset result;
                    List<String> matchOn;
                    int lastMetadataColumnIndex;
                    String[][] array2d;
                    File[] files = dir.listFiles();
                    File gistic = null;
                    File mutsig = null;
                    File homDeletions = null;
                    for (File f : files) {
                        String name = f.getName().toLowerCase();
                        if (name.contains("mutsig")) {
                            mutsig = f;
                            continue;
                        }
                        if (name.contains("gistic")) {
                            gistic = f;
                            continue;
                        }
                        if (!name.contains("homozygous_deletion")) continue;
                        homDeletions = f;
                    }
                    if (mutsig != null) {
                        try {
                            int i;
                            String[][] q = ((Array2DContentHandler)new ExcelReader(IOUtil.getPath(mutsig), new Array2DContentHandler()).getContentHandler()).getData();
                            Vector qValueVector = MetadataUtil.addRowVector(_dataset.getRowMetadata(), "q-value", Float.class);
                            int length = qValueVector.size();
                            for (i = 0; i < length; ++i) {
                                qValueVector.setValue(i, Float.valueOf(Float.NaN));
                            }
                            length = q.length;
                            for (i = 1; i < length; ++i) {
                                String[] row = q[i];
                                String gene = row[0];
                                float qValue = Float.parseFloat(row[1]);
                                Integer index = (Integer)geneToIndex.get(gene);
                                if (index == null) continue;
                                qValueVector.setValue(index, Float.valueOf(qValue));
                            }
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                    if (homDeletions != null) {
                        try {
                            array2d = ((Array2DContentHandler)new ExcelReader(homDeletions.getCanonicalPath(), null, (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
                            array2d[0][0] = "Id";
                            lastMetadataColumnIndex = Arrays.asList(array2d[0]).indexOf("Cytoband");
                            StringTableModel tableModel = new StringTableModel(array2d);
                            Dataset d = ProjectIO.readProject(tableModel, lastMetadataColumnIndex + 1, 1, MafFileImporter.HOMOZYGOUS_DEL).getOriginalDataset();
                            matchOn = Arrays.asList("Id", d.getColumnMetadata().get(0).getName());
                            result = DatasetUtil.concatenateRows(_dataset, d, matchOn.get(0), matchOn.get(1), _dataset.getName());
                            _dataset = result;
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                    if (gistic != null) {
                        try {
                            array2d = ((Array2DContentHandler)new ExcelReader(gistic.getCanonicalPath(), null, (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
                            array2d[0][1] = "Id";
                            array2d[0][5] = "q-value";
                            lastMetadataColumnIndex = Arrays.asList(array2d[0]).indexOf("AmplitudeThreshold");
                            StringTableModel tableModel = new StringTableModel(array2d);
                            Dataset d = ProjectIO.readProject(tableModel, lastMetadataColumnIndex + 1, 1, "GISTIC").getOriginalDataset();
                            matchOn = Arrays.asList("Id", d.getColumnMetadata().get(0).getName());
                            result = DatasetUtil.concatenateRows(_dataset, d, matchOn.get(0), matchOn.get(1), _dataset.getName());
                            _dataset = result;
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                }
                Vector sourceVector = _dataset.getRowMetadata().get("Source");
                Vector uniqueNameVector = _dataset.getRowMetadata().get("UniqueName");
                if (sourceVector != null) {
                    int size = sourceVector.size();
                    for (int i = 0; i < size; ++i) {
                        String value = (String)sourceVector.getValue(i);
                        if (!mafFileName.equals(value)) continue;
                        sourceVector.setValue(i, "MAF");
                    }
                    mafFileName = "MAF";
                    String amp = "GISTIC Amp";
                    String del = "GISTIC Del";
                    if (uniqueNameVector != null) {
                        int size2 = sourceVector.size();
                        for (int i = 0; i < size2; ++i) {
                            String value = (String)uniqueNameVector.getValue(i);
                            if (value == null) continue;
                            if (value.startsWith("Amplification Peak")) {
                                sourceVector.setValue(i, amp);
                                continue;
                            }
                            if (!value.startsWith("Deletion Peak")) continue;
                            sourceVector.setValue(i, del);
                        }
                    }
                    sourceVector.removeProperty("Text Visible");
                    sourceVector.setComparator(new Comparators.CustomSortOrderComparator(Arrays.asList(mafFileName, MafFileImporter.HOMOZYGOUS_DEL, amp, del)));
                }
                DefaultProject project = new DefaultProject(_dataset);
                ArrayList<SortKeys.VectorSortKey> rowSortOrder = new ArrayList<SortKeys.VectorSortKey>();
                if (sourceVector != null) {
                    rowSortOrder.add(new SortKeys.VectorSortKey("Source", SortOrder.ASCENDING, true));
                }
                if (_dataset.getRowMetadata().get("q-value") != null) {
                    CombinedFilter filter = new CombinedFilter();
                    Filters.RangeFilter rangeFilter = new Filters.RangeFilter("q-value");
                    rangeFilter.f1.setValue(0.0f);
                    filter.add(rangeFilter);
                    project.setRowFilter(filter);
                }
                if (rowSortOrder.size() > 0) {
                    project.setRowSortOrder(rowSortOrder);
                }
                if (sourceVector != null) {
                    project.setRowGroupBy(new ProjectSortKey[]{new SortKeys.VectorSortKey("Source", SortOrder.DESCENDING, true)});
                }
                project.setColumnSortOrder(Arrays.asList(new SortKeys.WaterFallSortKey(project, SortOrder.DESCENDING)));
                ProjectGENEEResultTreeNode n = new ProjectGENEEResultTreeNode(project, new History("Open file"));
                DefaultHeatMapColorScheme mafSColorScheme = new DefaultHeatMapColorScheme();
                if (homozygousIndex != -1) {
                    BetweenFloatFilter bt = new BetweenFloatFilter();
                    bt.f1.setValue(0.0f);
                    bt.f2.setValue(2.0f);
                    DefaultElementPainter.Condition predAndShape = new DefaultElementPainter.Condition(bt, ShapeUtil.getShape(1, 12.0f), -1, "homozygousix");
                    predAndShape.setEnabled(true);
                    predAndShape.setMarkColor(new Color(51, 204, 204));
                    predAndShape.setMark(DefaultElementPainter.Condition.MARK_CIRCLE);
                    mafSColorScheme.addCondition(predAndShape);
                }
                if (valueColumn != -1) {
                    BetweenFloatFilter bt = new BetweenFloatFilter();
                    bt.f1 = new GTE();
                    bt.f2 = new LTE();
                    bt.f1.setValue(-1.0f);
                    bt.f2.setValue(-1.0f);
                    DefaultElementPainter.Condition cond = new DefaultElementPainter.Condition(bt, ShapeUtil.getShape(1, 12.0f), -1, _dataset.getName());
                    cond.setEnabled(true);
                    cond.setFillColor(Color.WHITE);
                    cond.setBorderColor(Color.BLACK);
                    cond.setBorderStroke(new BasicStroke(2.0f));
                    mafSColorScheme.addCondition(cond);
                    mafSColorScheme.setMissingColor(Color.WHITE);
                    mafSColorScheme.setRelative(false);
                    mafSColorScheme.setGlobalMin(0.0f);
                    mafSColorScheme.setGlobalMax(1.0f);
                    mafSColorScheme.setColors(new Color[]{new Color(254, 217, 142), new Color(204, 76, 2), Color.BLACK});
                } else {
                    mafSColorScheme.setMissingColor(Color.WHITE);
                    mafSColorScheme.setRelative(false);
                    mafSColorScheme.setGlobalMax(1.0f);
                    mafSColorScheme.setGlobalMin(0.0f);
                    mafSColorScheme.setColors(new Color[]{Color.WHITE, Color.BLACK});
                }
                HeatMapPanel p = (HeatMapPanel)n.getDisplayInfo().getComponent();
                HeatMapColorSchemeSupplier cs = (HeatMapColorSchemeSupplier)p.getColorScheme();
                if (sourceVector == null) {
                    cs.setColorScheme(mafSColorScheme);
                } else {
                    cs.setSeparateColorSchemesForRowMetadataField("Source");
                    cs.setCurrentValue(mafFileName);
                    cs.setColorScheme(mafSColorScheme);
                    cs.setCurrentValue("GISTIC Del");
                    DefaultHeatMapColorScheme gisticDel = new DefaultHeatMapColorScheme(0.0f, 1.0f);
                    gisticDel.setColors(new Color[]{Color.WHITE, Color.BLUE});
                    cs.setColorScheme(gisticDel);
                    cs.setCurrentValue("GISTIC Amp");
                    DefaultHeatMapColorScheme gisticAmp = new DefaultHeatMapColorScheme(0.0f, 1.0f);
                    gisticAmp.setColors(new Color[]{Color.WHITE, Color.RED});
                    cs.setColorScheme(gisticAmp);
                    cs.setCurrentValue(MafFileImporter.HOMOZYGOUS_DEL);
                    DefaultHeatMapColorScheme homoDeletions = new DefaultHeatMapColorScheme(-1.0f, 0.0f);
                    homoDeletions.setColors(new Color[]{Color.BLUE, Color.WHITE});
                    cs.setColorScheme(homoDeletions);
                }
                p.setColorScheme(cs);
                return n;
            }

            @Override
            protected void succeeded(ProjectGENEEResultTreeNode node) {
                if (node != null) {
                    File f = new File(file);
                    if (f.exists()) {
                        node.setFile(f);
                    }
                    Application.add(new GENEEFolderNode("Open File", node.getAuditTrail().last(), node));
                }
            }
        }.execute();
    }
}

