/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.BreadthFirstEnumeration;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.matrix.MetadataUtil;

public abstract class MatchDatasetFieldsComponent {
    private JComponent bottomPanel;
    private JComboBox childNodeColumnsChooser;
    private JLabel childNodeLabel;
    private JComboBox childNodeRowsChooser;
    private ComboBoxParameter datasetComboBoxParameter = new ComboBoxParameter(null);
    private ProjectGENEEResultTreeNode selectedNode;
    private JComboBox selectedNodeColumnsChooser;
    private JComboBox selectedNodeRowsChooser;
    private JLabel selectedNodeLabel;
    private ActionListener datasetActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ProjectGENEEResultTreeNode selected = (ProjectGENEEResultTreeNode)MatchDatasetFieldsComponent.this.datasetComboBoxParameter.getSelectedItem();
            MatchDatasetFieldsComponent.this.updateUI(selected);
        }
    };

    public MatchDatasetFieldsComponent(boolean showRows, boolean showColumns) {
        this.datasetComboBoxParameter.addActionListener(this.datasetActionListener);
        this.childNodeRowsChooser = new JComboBox();
        this.childNodeColumnsChooser = new JComboBox();
        this.selectedNodeRowsChooser = new JComboBox();
        this.selectedNodeColumnsChooser = new JComboBox();
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setPreferredSize(new Dimension(800, 100));
        JPanel panel = new JPanel((LayoutManager)new FormLayout("p, 6px, p, 6px, p", "p, 4px, p, 4px, p"));
        CellConstraints cc = new CellConstraints();
        this.selectedNodeLabel = new JLabel("");
        panel.add((Component)this.selectedNodeLabel, cc.xy(3, 1));
        if (showRows) {
            panel.add((Component)new JLabel("Match row annotations on:"), cc.xy(1, 3));
            panel.add((Component)this.selectedNodeRowsChooser, cc.xy(3, 3));
            panel.add((Component)this.childNodeRowsChooser, cc.xy(5, 3));
        }
        if (showColumns) {
            panel.add((Component)this.selectedNodeColumnsChooser, cc.xy(3, 5));
            panel.add((Component)new JLabel("Match column annotations on:"), cc.xy(1, 5));
            panel.add((Component)this.childNodeColumnsChooser, cc.xy(5, 5));
        }
        this.childNodeLabel = new JLabel("");
        panel.add((Component)this.childNodeLabel, cc.xy(5, 1));
        this.bottomPanel.add(panel);
    }

    public void addDatasetActionListener(ActionListener l) {
        this.datasetComboBoxParameter.addActionListener(l);
    }

    public ProjectGENEEResultTreeNode getChildNode() {
        return (ProjectGENEEResultTreeNode)this.datasetComboBoxParameter.getSelectedItem();
    }

    public String getChildNodeColumnField() {
        return (String)this.childNodeColumnsChooser.getSelectedItem();
    }

    public String getChildNodeRowField() {
        return (String)this.childNodeRowsChooser.getSelectedItem();
    }

    public ComboBoxParameter getDatasetComponent() {
        return this.datasetComboBoxParameter;
    }

    public Component getMatchComponent() {
        return this.bottomPanel;
    }

    public String getSelectedNodeColumnField() {
        return (String)this.selectedNodeColumnsChooser.getSelectedItem();
    }

    public String getSelectedNodeRowField() {
        return (String)this.selectedNodeRowsChooser.getSelectedItem();
    }

    public boolean setSelectedNode(ProjectGENEEResultTreeNode node) {
        this.datasetComboBoxParameter.removeActionListener(this.datasetActionListener);
        Object selected = this.datasetComboBoxParameter.getSelectedItem();
        this.selectedNode = node;
        TreeNode root = Application.getNavigator().getRoot();
        BreadthFirstEnumeration e = new BreadthFirstEnumeration(root);
        this.datasetComboBoxParameter.removeAllItems();
        while (e.hasMoreElements()) {
            ProjectGENEEResultTreeNode childNode;
            TreeNode next = e.nextElement();
            if (!(next instanceof ProjectGENEEResultTreeNode) || (childNode = (ProjectGENEEResultTreeNode)next) == this.selectedNode || !this.accept(this.selectedNode, childNode)) continue;
            this.datasetComboBoxParameter.addItem(childNode);
        }
        this.datasetComboBoxParameter.setSelectedItem(selected);
        this.updateUI((ProjectGENEEResultTreeNode)this.datasetComboBoxParameter.getSelectedItem());
        this.datasetComboBoxParameter.addActionListener(this.datasetActionListener);
        return this.datasetComboBoxParameter.getSelectedItem() != null;
    }

    protected abstract boolean accept(ProjectGENEEResultTreeNode var1, ProjectGENEEResultTreeNode var2);

    private void updateUI(ProjectGENEEResultTreeNode childNode) {
        if (childNode != null && this.selectedNode != null) {
            this.selectedNodeLabel.setText(this.selectedNode.toString());
            this.childNodeLabel.setText(childNode.toString());
            String[] childNodeRowMetadataNames = MetadataUtil.getNames(childNode.getProject().getOriginalDataset().getRowMetadata()).toArray(new String[0]);
            String[] childNodeColumnMetadataNames = MetadataUtil.getNames(childNode.getProject().getOriginalDataset().getColumnMetadata()).toArray(new String[0]);
            String[] selectedNodeRowMetadataNames = MetadataUtil.getNames(this.selectedNode.getProject().getOriginalDataset().getRowMetadata()).toArray(new String[0]);
            String[] selectedNodeColumnMetadataNames = MetadataUtil.getNames(this.selectedNode.getProject().getOriginalDataset().getColumnMetadata()).toArray(new String[0]);
            MatchDatasetFieldsComponent.updateItems(this.childNodeRowsChooser, childNodeRowMetadataNames);
            MatchDatasetFieldsComponent.updateItems(this.childNodeColumnsChooser, childNodeColumnMetadataNames);
            MatchDatasetFieldsComponent.updateItems(this.selectedNodeRowsChooser, selectedNodeRowMetadataNames);
            MatchDatasetFieldsComponent.updateItems(this.selectedNodeColumnsChooser, selectedNodeColumnMetadataNames);
        }
    }

    private static void updateItems(JComboBox cb, String[] items) {
        Object selection = cb.getSelectedItem();
        cb.removeAllItems();
        for (String item : items) {
            cb.addItem(item);
        }
        cb.setSelectedItem(selection);
    }
}

