/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.clustering.hierarchical.AtrGtrDendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.OpenMapFile;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SeekableLineInputStreamTableModel;
import org.broadinstitute.genee.heatmap.menu.file.Importer;
import org.broadinstitute.genee.heatmap.menu.file.StringTableModel;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.matrix.gctx.GctxProjectReader;
import org.broadinstitute.genee.io.matrix.gctx.GctxReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class OpenDatasetFile {
    private OpenDatasetFile() {
    }

    public static void load(final String[] files) throws IOException {
        boolean isRnk = false;
        boolean isMap = false;
        for (String file : files) {
            String ext = IOUtil.getExtension(file);
            if ("rnk".equalsIgnoreCase(ext)) {
                isRnk = true;
                continue;
            }
            if (!"map".equalsIgnoreCase(ext)) continue;
            isMap = true;
        }
        if (isMap) {
            OpenMapFile.open(files[0]);
        } else if (isRnk) {
            new BackgroundTask<ProjectGENEEResultTreeNode>("Open File"){

                @Override
                protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
                    Dataset rankedList = ProjectIO.readProject(files[0]).getOriginalDataset();
                    Map rowNameToIndicesMap = VectorUtil.createValueToIndicesMap(rankedList.getRowMetadata().get(0));
                    TIntArrayList rows = new TIntArrayList();
                    for (TIntArrayList indices : rowNameToIndicesMap.values()) {
                        if (indices.size() != 1) continue;
                        rows.add(indices.getQuick(0));
                    }
                    rankedList = DatasetUtil.sliceView(rankedList, rows.toArray(), null);
                    Map rowNameToIndexMap = VectorUtil.createValueToIndexMap(rankedList.getRowMetadata().get(0));
                    RowMajorArray2DDataset combinedDataset = new RowMajorArray2DDataset("Ranked Lists", rankedList.getRowCount(), files.length);
                    Vector rowIds = MetadataUtil.addColumnVector(combinedDataset.getRowMetadata(), "id", String.class);
                    int nrows = combinedDataset.getRowCount();
                    for (int i = 0; i < nrows; ++i) {
                        rowIds.setValue(i, rankedList.getRowMetadata().getValue(i, 0));
                        combinedDataset.setValue(i, 0, rankedList.getValue(i, 0));
                        int ncols = combinedDataset.getColumnCount();
                        for (int j = 1; j < ncols; ++j) {
                            combinedDataset.setValue(i, j, Float.NaN);
                        }
                    }
                    Vector fileNameVector = MetadataUtil.addRowVector(combinedDataset.getColumnMetadata(), "Ranked List", String.class);
                    fileNameVector.setValue(0, IOUtil.getBaseFileName(rankedList.getName()));
                    for (int rankedListIndex = 1; rankedListIndex < files.length; ++rankedListIndex) {
                        rankedList = ProjectIO.readProject(files[rankedListIndex]).getOriginalDataset();
                        fileNameVector.setValue(rankedListIndex, IOUtil.getBaseFileName(rankedList.getName()));
                        int nrows2 = rankedList.getRowCount();
                        for (int i = 0; i < nrows2; ++i) {
                            Integer rowIndex = rowNameToIndexMap.get(rankedList.getRowMetadata().getValue(i, 0));
                            if (rowIndex == null) continue;
                            combinedDataset.setValue(rowIndex, rankedListIndex, rankedList.getValue(i, 0));
                        }
                    }
                    History map = new History("Open file");
                    return new ProjectGENEEResultTreeNode(new DefaultProject(combinedDataset), map);
                }

                @Override
                protected void succeeded(ProjectGENEEResultTreeNode node) {
                    if (node != null) {
                        File f;
                        if (files.length == 1 && (f = new File(files[0])).exists()) {
                            node.setFile(f);
                        }
                        Application.add(new GENEEFolderNode("Open File", node.getAuditTrail().last(), node));
                    }
                }
            }.execute();
        } else {
            for (String file : files) {
                OpenDatasetFile.load(file);
            }
        }
    }

    private static void load(final String file) throws FileNotFoundException {
        if (file == null) {
            return;
        }
        if (!new File(file).exists()) {
            throw new FileNotFoundException("File " + file + " not found.");
        }
        ProjectReader reader = ProjectIO.getProjectReader(file);
        if (reader == null) {
            OpenDatasetFile.doImport(file);
            return;
        }
        String atrFile = null;
        String gtrFile = null;
        String baseName = IOUtil.getBaseFileName(file);
        File f = new File(file);
        if (f.exists()) {
            File atr;
            File gtr = new File(f.getParentFile(), baseName + ".gtr");
            if (gtr.exists()) {
                try {
                    gtrFile = gtr.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((atr = new File(f.getParentFile(), baseName + ".atr")).exists()) {
                try {
                    atrFile = atr.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        final String _gtrFile = gtrFile;
        final String _atrFile = atrFile;
        new BackgroundTask<ProjectGENEEResultTreeNode>("Open File"){

            @Override
            protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
                return OpenDatasetFile.createNode(file, _atrFile, _gtrFile);
            }

            @Override
            protected void succeeded(ProjectGENEEResultTreeNode node) {
                if (node != null) {
                    File f = new File(file);
                    if (f.exists()) {
                        node.setFile(f);
                    }
                    Application.add(new GENEEFolderNode("Open File", node.getAuditTrail().last(), node));
                }
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectGENEEResultTreeNode createNode(String inputFile, String atrFile, String gtrFile) {
        Project p;
        ProjectReader reader;
        block28: {
            reader = ProjectIO.getProjectReader(inputFile);
            p = null;
            if (reader instanceof GctxProjectReader) {
                if (!new File(inputFile).exists()) {
                    try {
                        File tmpFile = File.createTempFile(IOUtil.getBaseFileName(inputFile), ".gctx");
                        IOUtil.download(inputFile, tmpFile);
                        inputFile = tmpFile.getCanonicalPath();
                        tmpFile.deleteOnExit();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try (GctxReader gctxReader = null;){
                    gctxReader = new GctxReader(inputFile);
                    if (gctxReader.getDatasetInfo().ncols <= 50000) break block28;
                    JComboBox columnFieldCombo = UIUtil.createComboBox(gctxReader.getRowsOrColumnNames(false).toArray());
                    JComboBox rowFieldCombo = UIUtil.createComboBox(gctxReader.getRowsOrColumnNames(true).toArray());
                    FormBuilder fb = new FormBuilder();
                    fb.nextRow();
                    fb.addSpanned(new JLabel("Please enter one column id per line (leave blank for all columns)"));
                    fb.nextRow();
                    if (columnFieldCombo.getItemCount() > 1) {
                        fb.addLabel("Field:");
                        fb.add(columnFieldCombo);
                        fb.nextRow();
                    }
                    JTextArea columnIdsTextArea = new JTextArea(10, 60);
                    fb.addLabel("Ids:");
                    fb.add(new JScrollPane(columnIdsTextArea));
                    fb.nextRow();
                    fb.addSpanned(new JLabel("Please enter one row id per line (leave blank for all rows)"));
                    fb.nextRow();
                    if (rowFieldCombo.getItemCount() > 1) {
                        fb.addLabel("Field:");
                        fb.add(rowFieldCombo);
                        fb.nextRow();
                    }
                    JTextArea rowIdsTextArea = new JTextArea(10, 60);
                    fb.addLabel("Ids:");
                    fb.add(new JScrollPane(rowIdsTextArea));
                    if (UIUtil.showOkCancelDialog(UIUtil.getCurrentFrame(), "Open GCTX", fb.getPanel(), "OK", "Cancel")) {
                        TIntArrayList columnIndices = new TIntArrayList();
                        String columnText = columnIdsTextArea.getText().trim();
                        if (!columnText.equals("")) {
                            Vector columnVector = gctxReader.getRowsOrColumns(false, null, new String[]{(String)columnFieldCombo.getSelectedItem()}).get(0);
                            Map columnValueToIndex = VectorUtil.createValueToIndexMap(columnVector);
                            for (String token : columnText.split("\n")) {
                                Integer index = columnValueToIndex.get(token);
                                if (index == null) continue;
                                columnIndices.add(index.intValue());
                            }
                        }
                        columnIndices.sort();
                        String rowText = rowIdsTextArea.getText().trim();
                        TIntArrayList rowIndices = new TIntArrayList();
                        if (!rowText.equals("")) {
                            Vector rowVector = gctxReader.getRowsOrColumns(true, null, new String[]{(String)rowFieldCombo.getSelectedItem()}).get(0);
                            Map rowValueToIndex = VectorUtil.createValueToIndexMap(rowVector);
                            for (String token : rowText.split("\n")) {
                                Integer index = rowValueToIndex.get(token);
                                if (index == null) continue;
                                rowIndices.add(index.intValue());
                            }
                        }
                        rowIndices.sort();
                        Dataset d = gctxReader.read(rowIndices.size() == 0 ? null : rowIndices.toArray(), columnIndices.size() == 0 ? null : columnIndices.toArray(), true, true, true, true);
                        d.setProperty("genee.options", gctxReader.getGENEEOptions());
                        p = new DefaultProject(d);
                        if (rowIndices.size() == 0) {
                            Dendrogram dend = gctxReader.getDendrogram(d.getRowMetadata(), true);
                            if (dend != null) {
                                p.setRowDendrogram(dend);
                            } else {
                                p.setRowDendrogram(OpenDatasetFile.getRowDendrogram(d, gtrFile));
                            }
                        }
                        if (columnIndices.size() == 0) {
                            Dendrogram dend = gctxReader.getDendrogram(d.getColumnMetadata(), false);
                            if (dend != null) {
                                p.setColumnDendrogram(dend);
                            } else {
                                p.setColumnDendrogram(OpenDatasetFile.getColumnDendrogram(d, atrFile));
                            }
                        }
                        break block28;
                    }
                    ProjectGENEEResultTreeNode projectGENEEResultTreeNode = null;
                    return projectGENEEResultTreeNode;
                }
            }
        }
        if (reader != null && p == null) {
            try {
                p = ProjectIO.readProject(inputFile);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if (p == null) {
            OpenDatasetFile.doImport(inputFile);
            return null;
        }
        Dataset dataset = p.getOriginalDataset();
        if (dataset != null) {
            AtrGtrDendrogram d = OpenDatasetFile.getRowDendrogram(dataset, gtrFile);
            if (d != null) {
                p.setRowDendrogram(d);
            }
            if ((d = OpenDatasetFile.getColumnDendrogram(dataset, atrFile)) != null) {
                p.setColumnDendrogram(d);
            }
            History map = new History("Open file");
            map.add("File", inputFile);
            return new ProjectGENEEResultTreeNode(p, map);
        }
        return null;
    }

    private static AtrGtrDendrogram getColumnDendrogram(Dataset dataset, String atrFile) {
        if (atrFile == null) {
            return null;
        }
        try {
            Vector v = dataset.getColumnMetadata().get("array id");
            if (v == null) {
                UIUtil.showErrorDialog(null, "array id not found-unable to open column dendrogram.");
                return null;
            }
            String[] arrayIds = new String[dataset.getColumnCount()];
            int columns = dataset.getColumnCount();
            for (int j = 0; j < columns; ++j) {
                arrayIds[j] = (String)v.getValue(j);
            }
            return new AtrGtrDendrogram(arrayIds, atrFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            UIUtil.showErrorDialog(null, "An error occurred while reading the file " + atrFile);
            return null;
        }
    }

    private static AtrGtrDendrogram getRowDendrogram(Dataset dataset, String gtrFile) {
        if (gtrFile == null) {
            return null;
        }
        try {
            String[] geneIds = new String[dataset.getRowCount()];
            int rows = dataset.getRowCount();
            for (int i = 0; i < rows; ++i) {
                geneIds[i] = (String)dataset.getRowMetadata().getValue(i, "gene id");
            }
            return new AtrGtrDendrogram(geneIds, gtrFile);
        }
        catch (IOException e) {
            UIUtil.showErrorDialog(null, "An error occurred while reading the file " + gtrFile);
            throw new RuntimeException(e);
        }
    }

    private static void doImport(final String file) {
        final boolean isExcelFile = ExcelReader.isExcelFile(file);
        File f = new File(file);
        if (isExcelFile || f.exists() && f.length() < 0x20000000L) {
            String sheet = null;
            if (isExcelFile) {
                Object[] sheets = ExcelReader.getSheetNames(file);
                sheet = sheets[0];
                if (sheets.length > 1) {
                    sheet = (String)JOptionPane.showInputDialog(UIUtil.getCurrentFrame(), "Select Excel Sheet", "Select Excel Sheet", -1, IconManager.loadIcon("heatmap-64.gif"), sheets, sheets[0]);
                }
            }
            final String _sheet = sheet;
            new BackgroundTask<TableModel>("Reading " + new File(file).getName()){

                @Override
                protected TableModel doInBackground() throws Exception {
                    try {
                        String[][] array2d = ((Array2DContentHandler)new ExcelReader(file, _sheet, (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
                        return new StringTableModel(array2d);
                    }
                    catch (OutOfMemoryError x) {
                        System.err.println("Not enough memory");
                        if (isExcelFile) {
                            throw x;
                        }
                        return new SeekableLineInputStreamTableModel(file);
                    }
                }

                @Override
                protected void succeeded(TableModel tableModel) {
                    new Importer(tableModel, new File(file).getName());
                }
            }.execute();
        } else {
            new BackgroundTask<TableModel>("Reading " + new File(file).getName()){

                @Override
                protected TableModel doInBackground() throws Exception {
                    return new SeekableLineInputStreamTableModel(file);
                }

                @Override
                protected void succeeded(TableModel tableModel) {
                    new Importer(tableModel, new File(file).getName());
                }
            }.execute();
        }
    }
}

