/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jidesoft.swing.JideSplitButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.DefaultViewableGENEETreeNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.cmap.gui.PlateViewerController;
import org.broadinstitute.genee.gui.ActionListenerHelper;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.DelimListDataIntelliHints;
import org.broadinstitute.genee.heatmap.AbstractIndexedQuickSearch;
import org.broadinstitute.genee.heatmap.AbstractQuickFilterPanel;
import org.broadinstitute.genee.heatmap.DisplayInfo;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.HeatMapToolBar;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class OpenMapFile {
    public static void open(final String file) {
        new BackgroundTask<ViewableGENEETreeNode>("Open File"){

            @Override
            protected ViewableGENEETreeNode doInBackground() throws Exception {
                final PlateViewerController controller = new PlateViewerController(file);
                controller.reset();
                final HeatMapPanel heatMapPanel = controller.getPlateViewer().getHeatMapPanel();
                heatMapPanel.setElementSelectionEnabled(false);
                DisplayInfo info = new DisplayInfo(heatMapPanel);
                HeatMapToolBar toolBar = controller.getPlateViewer().getHeatMapPanel().getToolBar();
                toolBar.setSearchVisible(false);
                toolBar.add(OpenMapFile.createDisplayButton("Well", controller, false));
                toolBar.add(OpenMapFile.createDisplayButton("Color", controller, true));
                toolBar.add(OpenMapFile.createDisplayButton("Shape", controller, true));
                toolBar.add(OpenMapFile.createDisplayButton("Text", controller, true));
                toolBar.add(OpenMapFile.createDisplayButton("Grid Color", controller, true));
                AbstractIndexedQuickSearch searchField = new AbstractIndexedQuickSearch(){
                    private Set<MatrixElement> matches;

                    @Override
                    protected LuceneSearchParser.SearchPredicateAdapterCreator createSearchPredicateAdapterCreator() {
                        return new LuceneSearchParser.SearchPredicateAdapterCreator(){

                            @Override
                            public LuceneSearchParser.IndexedSearchPredicate create(LuceneSearchParser.InternalSearchPredicate internalSearchPredicate) {
                                return new SeriesSearchPredicate(internalSearchPredicate);
                            }
                        };
                    }

                    @Override
                    protected Collection<String> getAvailableFieldNames() {
                        ArrayList<String> names = new ArrayList<String>();
                        int nseries = heatMapPanel.getProject().getOriginalDataset().getSeriesCount();
                        for (int i = 1; i < nseries; ++i) {
                            names.add(heatMapPanel.getProject().getOriginalDataset().getSeriesName(i));
                        }
                        return names;
                    }

                    @Override
                    protected String getSavedSearchKey() {
                        return "dataset.series.search";
                    }

                    @Override
                    protected void notifyFilterChanged() {
                        if (this.searchPredicate == null) {
                            this.matches = null;
                            this.clearLabelText();
                        } else {
                            this.matches = new HashSet<MatrixElement>();
                            Dataset dataset = heatMapPanel.getProject().getOriginalDataset();
                            SeriesSearchPredicate seriesSearchPredicate = (SeriesSearchPredicate)this.searchPredicate;
                            seriesSearchPredicate.setData(dataset);
                            int nrows = dataset.getRowCount();
                            for (int i = 0; i < nrows; ++i) {
                                int ncols = dataset.getColumnCount();
                                for (int j = 0; j < ncols; ++j) {
                                    if (!seriesSearchPredicate.accept(i, j)) continue;
                                    this.matches.add(new MatrixElement(i, j));
                                }
                            }
                            this.setLabelText(this.matches.size(), dataset.getRowCount() * dataset.getColumnCount());
                        }
                        ActionListenerHelper.fireActionPerformed(this.listenerList, new ActionEvent((Object)this, 1001, null));
                        controller.getPlateViewer().setMatchingSearchElements(this.matches);
                        controller.getPlateViewer().getHeatMapPanel().invalidateImage();
                    }
                };
                new DatasetSeriesAutocomplete(searchField, heatMapPanel.getProject());
                toolBar.add(searchField.getComponent());
                History history = new History("Open file");
                history.add("File", file);
                DefaultViewableGENEETreeNode node = new DefaultViewableGENEETreeNode(info, history);
                node.setUserObject(IOUtil.getBaseFileName(file));
                return node;
            }

            @Override
            protected void succeeded(ViewableGENEETreeNode node) {
                if (node != null) {
                    GENEEWindow window = Application.createViewWindow(node.toString());
                    window.getContentPane().add(node.getDisplayInfo().getComponent());
                    window.pack();
                    window.setVisible(true);
                }
            }
        }.execute();
    }

    private static JComponent createDisplayButton(final String property, final PlateViewerController controller, boolean showNone) {
        JideSplitButton displayBtn = new JideSplitButton(property);
        ButtonGroupHelper bg = new ButtonGroupHelper();
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menu = (JMenuItem)e.getSource();
                String series = menu.getText();
                if (series.equals("(None)")) {
                    series = null;
                }
                controller.setDisplay(property, series);
                controller.getPlateViewer().getHeatMapPanel().invalidateImage();
            }
        };
        if (showNone) {
            JCheckBoxMenuItem item = bg.createCheckBoxMenuItem("(None)", controller.getDisplay(property) == null);
            displayBtn.add((JMenuItem)item);
            item.addActionListener(l);
        }
        Dataset dataset = controller.getPlateViewer().getHeatMapPanel().getProject().getOriginalDataset();
        int nseries = dataset.getSeriesCount();
        for (int i = 1; i < nseries; ++i) {
            JCheckBoxMenuItem item = bg.createCheckBoxMenuItem(dataset.getSeriesName(i), dataset.getSeriesName(i).equals(controller.getDisplay(property)));
            displayBtn.add((JMenuItem)item);
            item.addActionListener(l);
        }
        return displayBtn;
    }

    private static class SeriesSearchPredicate
    implements LuceneSearchParser.IndexedSearchPredicate {
        private Dataset dataset;
        private LuceneSearchParser.InternalSearchPredicate internalSearchPredicate;
        private boolean all;
        private int seriesIndex = -1;

        public SeriesSearchPredicate(LuceneSearchParser.InternalSearchPredicate internalSearchPredicate) {
            this.internalSearchPredicate = internalSearchPredicate;
            String filterColumnName = internalSearchPredicate.getField();
            this.all = filterColumnName.equals("All");
        }

        @Override
        public boolean accept(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean accept(int rowIndex, int columnIndex) {
            if (this.all) {
                int nseries = this.dataset.getSeriesCount();
                for (int seriesIndex = 1; seriesIndex < nseries; ++seriesIndex) {
                    if (!this.accept(rowIndex, columnIndex, seriesIndex)) continue;
                    return true;
                }
            } else {
                return this.accept(rowIndex, columnIndex, this.seriesIndex);
            }
            return false;
        }

        @Override
        public void setData(Object data) {
            this.dataset = (Dataset)data;
            if (!this.all) {
                this.seriesIndex = DatasetUtil.getSeriesIndex(this.dataset, this.internalSearchPredicate.getField());
            }
        }

        private boolean accept(int rowIndex, int columnIndex, int seriesIndex) {
            Object value = null;
            if (!this.internalSearchPredicate.isNumber()) {
                value = this.dataset.getObjectValue(rowIndex, columnIndex, seriesIndex);
                if (value != null) {
                    value = value.toString();
                }
            } else if (this.internalSearchPredicate.isNumber() && Number.class.isAssignableFrom(this.dataset.getSeriesClass(seriesIndex))) {
                value = this.dataset.getObjectValue(rowIndex, columnIndex, seriesIndex);
            }
            return value != null ? this.internalSearchPredicate.accept(value) : false;
        }
    }

    private static class DatasetSeriesAutocomplete
    extends DelimListDataIntelliHints {
        private AbstractQuickFilterPanel quickSearch;
        private Project project;

        public DatasetSeriesAutocomplete(AbstractQuickFilterPanel qf, Project project) {
            super(qf.getTextField());
            this.quickSearch = qf;
            this.project = project;
        }

        @Override
        public Collection<String> getMatches(String text) {
            boolean caseSensitive = this.isCaseSensitive();
            TreeSet<String> matches = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            String field = this.quickSearch.getDefaultFilterColumnName();
            Dataset dataset = this.project.getSortedFilteredDataset();
            int[] seriesIndices = field.equals("All") ? IOUtil.seqInt(1, dataset.getSeriesCount() - 1, 1) : new int[]{DatasetUtil.getSeriesIndex(dataset, field)};
            int nrows = dataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                int ncols = dataset.getColumnCount();
                for (int j = 0; j < ncols; ++j) {
                    for (int seriesIndex : seriesIndices) {
                        String stringValue;
                        Object value = dataset.getObjectValue(i, j, seriesIndex);
                        if (value == null) continue;
                        String _value = stringValue = value.toString();
                        if (!caseSensitive) {
                            _value = _value.toLowerCase();
                        }
                        if (!_value.startsWith(text)) continue;
                        matches.add(stringValue);
                    }
                }
            }
            return matches;
        }
    }
}

