/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.OpenFileListener;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class OpenRecentMenu
extends JMenu
implements MenuListener {
    public static final String OPEN_RECENT = "open.recent";
    private static Preferences prefs = Preferences.userNodeForPackage(OpenRecentMenu.class);
    private static List<File> recentFiles = new ArrayList<File>();

    public OpenRecentMenu() {
        super("Open Recent");
        this.addMenuListener(this);
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent event) {
        this.rebuildMenu();
    }

    private void rebuildMenu() {
        this.removeAll();
        for (final File file : recentFiles) {
            String title = file.getName();
            AbstractAction openRecentAction = new AbstractAction(title){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackerUtil.trackPageView("Open Recent");
                    try {
                        OpenFileListener[] listeners;
                        for (OpenFileListener l : listeners = Application.getOpenFileActionListeners()) {
                            l.open(new String[]{file.getCanonicalPath()}, null);
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            };
            openRecentAction.putValue("ShortDescription", IOUtil.getPath(file));
            this.add(openRecentAction);
        }
        if (this.getItemCount() > 0) {
            this.add(new JSeparator());
        }
        AbstractAction clearMenuItem = new AbstractAction("Clear Menu"){

            @Override
            public void actionPerformed(ActionEvent e) {
                prefs.remove(OpenRecentMenu.OPEN_RECENT);
                recentFiles.clear();
                try {
                    prefs.sync();
                }
                catch (BackingStoreException e1) {
                    e1.printStackTrace();
                }
                OpenRecentMenu.this.rebuildMenu();
            }
        };
        clearMenuItem.setEnabled(recentFiles.size() > 0);
        this.add(clearMenuItem);
    }

    public static void updateRecentFilesList(File file) {
        if (!file.exists()) {
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(OpenRecentMenu.class);
        String currentValue = prefs.get(OPEN_RECENT, null);
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<String> uniqueFiles = new LinkedHashSet<String>();
        uniqueFiles.add(IOUtil.getPath(file));
        if (currentValue != null) {
            String[] filesArray = currentValue.split(";");
            int length = filesArray.length;
            for (int i = 0; i < length && uniqueFiles.size() < 11; ++i) {
                if (filesArray[i].trim().equals("")) continue;
                uniqueFiles.add(filesArray[i]);
            }
            for (String uniqueFile : uniqueFiles) {
                sb.append(";");
                sb.append(uniqueFile);
            }
        }
        recentFiles.clear();
        for (String path : uniqueFiles) {
            recentFiles.add(new File(path));
        }
        Collections.sort(recentFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        prefs.put(OPEN_RECENT, sb.toString());
        try {
            prefs.sync();
        }
        catch (BackingStoreException e1) {
            e1.printStackTrace();
        }
    }

    private static void fetchFromPrefs() {
        String recentFilesString = prefs.get(OPEN_RECENT, null);
        String[] files = null;
        recentFiles.clear();
        if (recentFilesString != null) {
            for (String file : files = recentFilesString.split(";")) {
                File f;
                if (file.equals("") || !(f = new File(file)).exists()) continue;
                recentFiles.add(f);
            }
            Collections.sort(recentFiles, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
        }
    }

    static {
        new Thread(){

            @Override
            public void run() {
                OpenRecentMenu.fetchFromPrefs();
            }
        }.start();
    }
}

