/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gnu.trove.set.hash.TIntHashSet;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.heatmap.AbstractProjectQuickSearch;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.HeatMapToolBar;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;

public class SearchComponents {
    private JButton bringMatchesToTopButton;
    private boolean bringSearchMatchesToTop;
    private HeatMapPanel heatMapPanel;
    private JButton highlightNextButton;
    private JButton highlightPreviousButton;
    private AbstractProjectQuickSearch quickSearch;
    private boolean row;
    private JButton saveSearchButton;
    private JButton selectAllMatchesButton;

    public SearchComponents(final HeatMapPanel heatMapPanel, final AbstractProjectQuickSearch quickSearch, final boolean row) {
        ActionListener l;
        KeyStroke ks;
        this.row = row;
        this.heatMapPanel = heatMapPanel;
        this.quickSearch = quickSearch;
        quickSearch.setHintText(row ? "Search Rows" : "Search Columns");
        quickSearch.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean empty = quickSearch.isEmpty();
                SearchComponents.this.highlightNextButton.setEnabled(!empty);
                SearchComponents.this.highlightPreviousButton.setEnabled(!empty);
                SearchComponents.this.selectAllMatchesButton.setEnabled(!empty && quickSearch.getNumberOfMatches() > 0);
                SearchComponents.this.saveSearchButton.setEnabled(!empty);
                SearchComponents.this.bringMatchesToTopButton.setEnabled(!empty);
                if (!SearchComponents.this.bringMatchesToTopButton.isEnabled()) {
                    Project project = quickSearch.getProject();
                    List sortKeys = SearchComponents.this.getSortKeys();
                    if (sortKeys.size() > 0 && sortKeys.get(0) instanceof SortKeys.SelectedIndicesFirstSortKey) {
                        sortKeys.remove(0);
                        if (row) {
                            project.setRowSortOrder(sortKeys);
                        } else {
                            project.setColumnSortOrder(sortKeys);
                        }
                    }
                }
                if (!quickSearch.isEmpty() && SearchComponents.this.bringSearchMatchesToTop) {
                    quickSearch.removeActionListener(this);
                    try {
                        List sortKeys = SearchComponents.this.getSortKeys();
                        SearchComponents.this.bringMatchesToTop(sortKeys);
                        if (row) {
                            quickSearch.getProject().setRowSortOrder(sortKeys);
                        } else {
                            quickSearch.getProject().setColumnSortOrder(sortKeys);
                        }
                    }
                    finally {
                        quickSearch.addActionListener(this);
                    }
                }
            }
        });
        this.selectAllMatchesButton = new JButton(IconManager.loadIcon("16x16/49299.sc_selectall.png"));
        this.selectAllMatchesButton.setToolTipText("Select all matches. Shift-click to add to selection.");
        this.selectAllMatchesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean add = (e.getModifiers() & 1) != 0;
                SearchComponents.this.selectAllMatches(add);
            }
        });
        this.saveSearchButton = new JButton(IconManager.loadIcon("16x16/48963.sc_saveas.png"));
        this.saveSearchButton.setToolTipText("Save this search");
        this.saveSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                quickSearch.saveSearch();
            }
        });
        this.bringMatchesToTopButton = new JButton(IconManager.loadIcon("16x16/1369895138_go-top.png"));
        this.bringMatchesToTopButton.setToolTipText("Bring matches to top");
        this.bringMatchesToTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchComponents.this.bringSearchMatchesToTop = !SearchComponents.this.bringSearchMatchesToTop;
                List sortKeys = SearchComponents.this.getSortKeys();
                SearchComponents.removeSelectedIndicesFirstSortKey(sortKeys);
                if (SearchComponents.this.bringSearchMatchesToTop) {
                    SearchComponents.this.bringMatchesToTop(sortKeys);
                }
                Project project = quickSearch.getProject();
                if (row) {
                    project.setRowSortOrder(sortKeys);
                } else {
                    project.setColumnSortOrder(sortKeys);
                }
            }
        });
        this.highlightNextButton = new JButton(IconManager.loadIcon("16x16/13960.navigate-next.gif"));
        this.highlightNextButton.setToolTipText("Go to the next match");
        if (row) {
            ks = KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SearchComponents.this.highlightNextButton.isEnabled()) {
                        SearchComponents.this.highlightNextButton.doClick();
                    }
                }
            };
            heatMapPanel.registerKeyboardAction(l, "Find Next", ks, 1);
        }
        this.highlightNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int next = quickSearch.nextMatch();
                if (row) {
                    heatMapPanel.scrollToRow(next);
                } else {
                    heatMapPanel.scrollToColumn(next);
                }
            }
        });
        this.highlightPreviousButton = new JButton(IconManager.loadIcon("16x16/13964.navigate-previous.gif"));
        this.highlightPreviousButton.setToolTipText("Go to the previous match");
        if (row) {
            ks = KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1);
            l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SearchComponents.this.highlightPreviousButton.isEnabled()) {
                        SearchComponents.this.highlightPreviousButton.doClick();
                    }
                }
            };
            heatMapPanel.registerKeyboardAction(l, "Find Previous", ks, 1);
        }
        this.highlightPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int previous = quickSearch.previousMatch();
                if (row) {
                    heatMapPanel.scrollToRow(previous);
                } else {
                    heatMapPanel.scrollToColumn(previous);
                }
            }
        });
        HeatMapToolBar.configure(this.selectAllMatchesButton);
        HeatMapToolBar.configure(this.highlightPreviousButton);
        HeatMapToolBar.configure(this.highlightNextButton);
        HeatMapToolBar.configure(this.saveSearchButton);
        HeatMapToolBar.configure(this.bringMatchesToTopButton);
        this.highlightNextButton.setEnabled(false);
        this.highlightPreviousButton.setEnabled(false);
        this.selectAllMatchesButton.setEnabled(false);
        this.saveSearchButton.setEnabled(false);
        this.bringMatchesToTopButton.setEnabled(false);
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel((LayoutManager)new FormLayout("p:g, p, p, p, p, p", "p:g"));
        CellConstraints cc = new CellConstraints();
        panel.add(this.getSearchField(), cc.xy(1, 1));
        panel.add(this.getHighlightPrevious(), cc.xy(2, 1));
        panel.add(this.getHighlightNext(), cc.xy(3, 1));
        panel.add((Component)this.getSelectAllMatchesButton(), cc.xy(4, 1));
        panel.add((Component)this.getSaveSearchButton(), cc.xy(5, 1));
        panel.add((Component)this.getBringMatchesToTopButton(), cc.xy(6, 1));
        return panel;
    }

    public JButton getBringMatchesToTopButton() {
        return this.bringMatchesToTopButton;
    }

    public Component getHighlightNext() {
        return this.highlightNextButton;
    }

    public Component getHighlightPrevious() {
        return this.highlightPreviousButton;
    }

    public AbstractProjectQuickSearch getQuickFilter() {
        return this.quickSearch;
    }

    public AbstractProjectQuickSearch getQuickSearch() {
        return this.quickSearch;
    }

    public JButton getSaveSearchButton() {
        return this.saveSearchButton;
    }

    public Component getSearchField() {
        return this.quickSearch.getComponent();
    }

    public JButton getSelectAllMatchesButton() {
        return this.selectAllMatchesButton;
    }

    public void selectAllMatches(boolean addToSelection) {
        int[] indices = this.quickSearch.getHighlightedIndices();
        Project project = this.quickSearch.getProject();
        int[] priorSelection = new int[]{};
        if (this.row) {
            if (addToSelection) {
                priorSelection = project.getRowSelectionModel().getSelectedModelIndices();
            }
            TIntHashSet set = new TIntHashSet();
            int length = indices.length;
            for (int i = 0; i < length; ++i) {
                set.add(project.convertViewRowIndexToModel(indices[i]));
            }
            for (int prior : priorSelection) {
                set.add(prior);
            }
            project.setSelectedModelRowIndices(set.toArray());
            this.heatMapPanel.getRowTable().requestFocusInWindow();
        } else {
            if (addToSelection) {
                priorSelection = project.getColumnSelectionModel().getSelectedModelIndices();
            }
            TIntHashSet set = new TIntHashSet();
            int length = indices.length;
            for (int i = 0; i < length; ++i) {
                set.add(project.convertViewColumnIndexToModel(indices[i]));
            }
            for (int prior : priorSelection) {
                set.add(prior);
            }
            project.setSelectedModelColumnIndices(set.toArray());
            this.heatMapPanel.getColumnTable().requestFocusInWindow();
        }
    }

    public void setVisible(boolean b) {
        this.quickSearch.setVisible(b);
        this.highlightPreviousButton.setVisible(b);
        this.highlightNextButton.setVisible(b);
        this.selectAllMatchesButton.setVisible(b);
        this.saveSearchButton.setVisible(b);
        this.bringMatchesToTopButton.setVisible(b);
    }

    protected void bringMatchesToTop(List<ProjectSortKey> sortKeys) {
        Project project = this.quickSearch.getProject();
        int[] viewIndices = this.quickSearch.getHighlightedIndices();
        HashSet<Integer> modelIndices = new HashSet<Integer>();
        if (this.row) {
            int length = viewIndices.length;
            for (int i = 0; i < length; ++i) {
                modelIndices.add(project.convertViewRowIndexToModel(viewIndices[i]));
            }
        } else {
            int length = viewIndices.length;
            for (int i = 0; i < length; ++i) {
                modelIndices.add(project.convertViewColumnIndexToModel(viewIndices[i]));
            }
        }
        SearchComponents.removeSelectedIndicesFirstSortKey(sortKeys);
        sortKeys.add(0, new SortKeys.SelectedIndicesFirstSortKey(modelIndices));
    }

    private List<ProjectSortKey> getSortKeys() {
        Project project = this.quickSearch.getProject();
        return this.row ? new ArrayList<ProjectSortKey>(project.getRowSortKeys()) : new ArrayList<ProjectSortKey>(project.getColumnSortKeys());
    }

    private static void removeSelectedIndicesFirstSortKey(List<ProjectSortKey> sortKeys) {
        int size = sortKeys.size();
        for (int i = 0; i < size; ++i) {
            ProjectSortKey key = sortKeys.get(i);
            if (!(key instanceof SortKeys.SelectedIndicesFirstSortKey)) continue;
            sortKeys.remove(i);
            --i;
            --size;
        }
    }
}

