/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;

public class SelectionPanel
extends JPanel {
    private Project project;
    private ProjectListener projectListener;
    private JLabel statusLabel;

    public SelectionPanel(final Project project) {
        this.project = project;
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(this.statusLabel.getFont().getSize2D() - 1.0f));
        this.updateLabelText();
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                SelectionPanel.this.updateLabelText();
            }
        };
        project.addProjectListener(this.projectListener);
        final JLabel selectionLabel = new JLabel("    ");
        selectionLabel.setFont(selectionLabel.getFont().deriveFont(selectionLabel.getFont().getSize2D() - 1.0f));
        SelectionListener l = new SelectionListener(){

            @Override
            public void valueChanged(SelectionEvent e) {
                int rowCount = project.getRowSelectionModel().getSelectionCount();
                int columnCount = project.getColumnSelectionModel().getSelectionCount();
                StringBuilder text = new StringBuilder();
                if (rowCount > 0) {
                    text.append(rowCount);
                    text.append(" ");
                    text.append(rowCount == 1 ? "row" : "rows");
                    if (columnCount > 0) {
                        text.append(", ");
                    }
                }
                if (columnCount > 0) {
                    text.append(columnCount);
                    text.append(" ");
                    text.append(columnCount == 1 ? "column" : "columns");
                }
                if (rowCount > 0 || columnCount > 0) {
                    text.append(" selected");
                }
                selectionLabel.setText(text.toString());
            }
        };
        project.getRowSelectionModel().addSelectionListener(l);
        project.getColumnSelectionModel().addSelectionListener(l);
        this.setLayout((LayoutManager)new FormLayout("6px, left:pref:g, 25px, right:pref:g, 20px", "pref"));
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.statusLabel, cc.xy(2, 1));
        this.add((Component)selectionLabel, cc.xy(4, 1));
    }

    private void updateLabelText() {
        int rowCount = this.project.getViewRowCount();
        int columnCount = this.project.getViewColumnCount();
        if (this.project.getOriginalDataset() == null) {
            this.statusLabel.setText("");
        } else {
            int datasetRowCount = this.project.getOriginalDataset().getRowCount();
            int datasetColumnCount = this.project.getOriginalDataset().getColumnCount();
            this.statusLabel.setText("Showing " + rowCount + " out of " + datasetRowCount + (datasetRowCount == 1 ? " row" : " rows") + ", " + columnCount + " out of " + datasetColumnCount + " " + (datasetColumnCount == 1 ? "column" : "columns"));
        }
    }
}

