/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.heatmap.AbstractSortDialog;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.matrix.MetadataModel;

public class SortColumnsDialog
extends AbstractSortDialog {
    public SortColumnsDialog(HeatMapPanel heatMapPanel) {
        super(heatMapPanel, false);
    }

    @Override
    protected List<ProjectSortKey> createComboBoxItems() {
        Project project = Application.getProject();
        MetadataModel metadata = project.getOriginalDataset().getColumnMetadata();
        ArrayList<ProjectSortKey> sortColumns = new ArrayList<ProjectSortKey>(metadata.getMetadataCount());
        sortColumns.add(AbstractSortDialog.EmptySortKey.INSTANCE);
        int size = metadata.getMetadataCount();
        for (int j = 0; j < size; ++j) {
            sortColumns.add(new SortKeys.VectorSortKey(metadata.getColumnName(j), SortOrder.UNSORTED, false));
        }
        sortColumns.add(new SortKeys.WaterFallSortKey(project, SortOrder.UNSORTED));
        return sortColumns;
    }

    @Override
    protected void setGroupBy(ProjectSortKey[] sortKey) {
        Application.getProject().setColumnGroupBy(sortKey);
    }

    @Override
    protected void setSortOrder(List<ProjectSortKey> sortKeys) {
        Application.getProject().setColumnSortOrder(sortKeys);
    }
}

