/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import org.broadinstitute.genee.heatmap.CoordinateMapper;

public class WorldCoordinateMapper
implements CoordinateMapper {
    private float bottomGutter;
    private boolean clipX;
    private boolean clipY;
    private float height;
    private float leftGutter;
    private float maxXPixPerUnit = Float.NaN;
    private float maxYPixPerUnit = Float.NaN;
    private float minXPixPerUnit = Float.NaN;
    private float minYPixPerUnit = Float.NaN;
    private float[] pixelMatrix = new float[6];
    private float rightGutter;
    private boolean squareAspect = false;
    private float topGutter;
    private float width;
    private float xmax;
    private float xmin;
    private float xPixPerUnit;
    private float ymax;
    private float ymin;
    private float yPixPerUnit;

    public WorldCoordinateMapper() {
    }

    public WorldCoordinateMapper(CoordinateMapper copy) {
        this.bottomGutter = copy.getBottomGutter();
        this.leftGutter = copy.getLeftGutter();
        this.rightGutter = copy.getRightGutter();
        this.topGutter = copy.getTopGutter();
        this.xmax = copy.getXMax();
        this.xmin = copy.getXMin();
        this.ymax = copy.getYMax();
        this.ymin = copy.getYMin();
    }

    @Override
    public float getBottomGutter() {
        return this.bottomGutter;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getLeftGutter() {
        return this.leftGutter;
    }

    @Override
    public float getRightGutter() {
        return this.rightGutter;
    }

    @Override
    public float getTopGutter() {
        return this.topGutter;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getXMax() {
        return this.xmax;
    }

    @Override
    public float getXMin() {
        return this.xmin;
    }

    @Override
    public float getXPixPerUnit() {
        return this.xPixPerUnit;
    }

    @Override
    public float getYMax() {
        return this.ymax;
    }

    @Override
    public float getYMin() {
        return this.ymin;
    }

    @Override
    public float getYPixPerUnit() {
        return this.yPixPerUnit;
    }

    @Override
    public float pixToX(float pix) {
        float x = this.xmin + (pix - this.leftGutter) / this.xPixPerUnit;
        if (this.clipX) {
            if (this.xmin < this.xmax) {
                if (x < this.xmin) {
                    x = this.xmin;
                } else if (x > this.xmax) {
                    x = this.xmax;
                }
            } else if (x > this.xmin) {
                x = this.xmin;
            } else if (x < this.xmax) {
                x = this.xmax;
            }
        }
        return x;
    }

    @Override
    public float pixToY(float pix) {
        float y = this.ymax - (pix - this.topGutter) / this.yPixPerUnit;
        if (this.clipY) {
            if (this.ymin < this.ymax) {
                if (y < this.ymin) {
                    y = this.ymin;
                } else if (y > this.ymax) {
                    y = this.ymax;
                }
            } else if (y > this.ymin) {
                y = this.ymin;
            } else if (y < this.ymax) {
                y = this.ymax;
            }
        }
        return y;
    }

    @Override
    public void setBottomGutter(float bottomGutter) {
        this.bottomGutter = bottomGutter;
    }

    @Override
    public void setClipX(boolean clipX) {
        this.clipX = clipX;
    }

    @Override
    public void setClipY(boolean clipY) {
        this.clipY = clipY;
    }

    @Override
    public void setLeftGutter(float leftGutter) {
        this.leftGutter = leftGutter;
    }

    @Override
    public void setRightGutter(float rightGutter) {
        this.rightGutter = rightGutter;
    }

    @Override
    public void setSquareAspect(boolean squareAspect) {
        this.squareAspect = squareAspect;
    }

    @Override
    public void setTopGutter(float topGutter) {
        this.topGutter = topGutter;
    }

    @Override
    public void setXMax(float xmax) {
        this.xmax = xmax;
    }

    @Override
    public void setXMin(float xmin) {
        this.xmin = xmin;
    }

    @Override
    public void setXPixelScale(float width) {
        this.width = width;
        float range = this.xmax - this.xmin;
        this.xPixPerUnit = (width - this.leftGutter - this.rightGutter) / range;
        if (!Float.isNaN(this.minXPixPerUnit)) {
            this.xPixPerUnit = Math.max(this.xPixPerUnit, this.minXPixPerUnit);
        }
        if (!Float.isNaN(this.maxXPixPerUnit)) {
            this.xPixPerUnit = Math.min(this.xPixPerUnit, this.maxXPixPerUnit);
        }
        this.setScale();
    }

    @Override
    public void setXYPixelScale(float width, float height) {
        this.setXPixelScale(width);
        this.setYPixelScale(height);
    }

    @Override
    public void setYMax(float ymax) {
        this.ymax = ymax;
    }

    @Override
    public void setYMin(float ymin) {
        this.ymin = ymin;
    }

    @Override
    public void setYPixelScale(float height) {
        this.height = height;
        this.yPixPerUnit = (height - this.bottomGutter - this.topGutter) / (this.ymax - this.ymin);
        if (!Float.isNaN(this.minYPixPerUnit)) {
            this.yPixPerUnit = Math.max(this.yPixPerUnit, this.minYPixPerUnit);
        }
        if (!Float.isNaN(this.maxYPixPerUnit)) {
            this.yPixPerUnit = Math.min(this.yPixPerUnit, this.maxYPixPerUnit);
        }
        this.setScale();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("left gutter:");
        buf.append(this.leftGutter);
        buf.append("\nright gutter:");
        buf.append(this.rightGutter);
        buf.append("\ntop gutter:");
        buf.append(this.topGutter);
        buf.append("\nbottom gutter:");
        buf.append(this.bottomGutter);
        buf.append("\nxPixPerUnit:");
        buf.append(this.xPixPerUnit);
        buf.append("\nyPixPerUnit:");
        buf.append(this.yPixPerUnit);
        return buf.toString();
    }

    @Override
    public float xToPix(float x) {
        if (this.clipX) {
            if (this.xmin < this.xmax) {
                if (x < this.xmin) {
                    x = this.xmin;
                } else if (x > this.xmax) {
                    x = this.xmax;
                }
            } else if (x > this.xmin) {
                x = this.xmin;
            } else if (x < this.xmax) {
                x = this.xmax;
            }
        }
        return this.pixelMatrix[0] * x + this.pixelMatrix[4];
    }

    @Override
    public float yToPix(float y) {
        if (Float.isNaN(y)) {
            return Float.NaN;
        }
        if (this.clipY) {
            if (this.ymin < this.ymax) {
                if (y < this.ymin) {
                    y = this.ymin;
                } else if (y > this.ymax) {
                    y = this.ymax;
                }
            } else if (y > this.ymin) {
                y = this.ymin;
            } else if (y < this.ymax) {
                y = this.ymax;
            }
        }
        return this.pixelMatrix[3] * y + this.pixelMatrix[5];
    }

    private void setScale() {
        if (this.squareAspect) {
            float pixPerUnit;
            this.xPixPerUnit = pixPerUnit = Math.min(this.xPixPerUnit, this.yPixPerUnit);
            this.yPixPerUnit = pixPerUnit;
        }
        this.pixelMatrix[0] = this.xPixPerUnit;
        this.pixelMatrix[1] = 0.0f;
        this.pixelMatrix[2] = 0.0f;
        this.pixelMatrix[3] = -this.yPixPerUnit;
        this.pixelMatrix[4] = -this.xmin * this.xPixPerUnit + this.leftGutter;
        this.pixelMatrix[5] = this.ymax * this.yPixPerUnit + this.topGutter;
    }

    public static float getPixPerUnit(float size, float max, float min) {
        return Math.abs(size / (max - min));
    }

    public static float linearScale(float value, float input0, float input1, float pix0, float pix1) {
        return (value - input0) / (input1 - input0) * (pix1 - pix0) + pix0;
    }
}

