/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.SelectMissingAction;
import org.broadinstitute.genee.heatmap.menu.ClearSelectionAction;
import org.broadinstitute.genee.heatmap.menu.CreateComputedVectorAction;
import org.broadinstitute.genee.heatmap.menu.InvertSelectionAction;
import org.broadinstitute.genee.heatmap.menu.SelectAllAction;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class EditMenu
extends JMenu {
    public EditMenu(final HeatMapPanel heatMapPanel) {
        super("Edit");
        this.add(heatMapPanel.getHeatMapEditorKit().getEditColumnAnnotationsAction());
        this.add(heatMapPanel.getHeatMapEditorKit().getEditRowAnnotationsAction());
        this.add(new JSeparator());
        this.add(new CreateComputedVectorAction(false));
        this.add(new CreateComputedVectorAction(true));
        this.add(new JSeparator());
        this.add(heatMapPanel.getHeatMapEditorKit().getCopyAction());
        this.add(new JSeparator());
        JMenu columnSelectionMenu = new JMenu("Column Selection");
        JMenu rowSelectionMenu = new JMenu("Row Selection");
        columnSelectionMenu.add(new SelectAllAction(heatMapPanel, false));
        rowSelectionMenu.add(new SelectAllAction(heatMapPanel, true));
        columnSelectionMenu.add(new InvertSelectionAction(heatMapPanel, false));
        rowSelectionMenu.add(new InvertSelectionAction(heatMapPanel, true));
        columnSelectionMenu.add(new SelectMissingAction(heatMapPanel, false));
        rowSelectionMenu.add(new SelectMissingAction(heatMapPanel, true));
        columnSelectionMenu.add(new ClearSelectionAction(heatMapPanel, false));
        rowSelectionMenu.add(new ClearSelectionAction(heatMapPanel, true));
        this.add(columnSelectionMenu);
        this.add(rowSelectionMenu);
        this.add(new JSeparator());
        JMenu columnMaskMenu = new JMenu("Column Mask");
        columnMaskMenu.add(heatMapPanel.getHeatMapEditorKit().getMaskColumnsAction());
        columnMaskMenu.add(heatMapPanel.getHeatMapEditorKit().getUnMaskColumnsAction());
        columnMaskMenu.add(heatMapPanel.getHeatMapEditorKit().getResetMaskColumnsAction());
        this.add(columnMaskMenu);
        JMenu rowMaskMenu = new JMenu("Row Mask");
        rowMaskMenu.add(heatMapPanel.getHeatMapEditorKit().getMaskRowsAction());
        rowMaskMenu.add(heatMapPanel.getHeatMapEditorKit().getUnMaskRowsAction());
        rowMaskMenu.add(heatMapPanel.getHeatMapEditorKit().getResetMaskRowsAction());
        this.add(rowMaskMenu);
        this.add(new JSeparator());
        AbstractAction searchColumnsAction = new AbstractAction("Search Columns"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerUtil.trackPageView((String)this.getValue("Name"));
                heatMapPanel.grabColumnSearchFocus();
            }
        };
        searchColumnsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, UIUtil.getMenuShortcutKeyMask() | 1));
        this.add(searchColumnsAction);
        AbstractAction searchRowsAction = new AbstractAction("Search Rows"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerUtil.trackPageView((String)this.getValue("Name"));
                heatMapPanel.grabRowSearchFocus();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(70, UIUtil.getMenuShortcutKeyMask());
        searchRowsAction.putValue("AcceleratorKey", ks);
        this.add(searchRowsAction);
        if (heatMapPanel.getProject().getOriginalDataset().getRowCount() == 0) {
            UIUtil.setChildrenEnabledRecursively(this, false);
        }
    }
}

