/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.Color;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.AbstractGenericInputAction;
import org.broadinstitute.genee.gui.BlockingThread;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class SaveAnnotationColors
extends AbstractGenericInputAction<Void> {
    public SaveAnnotationColors() {
        super("Save annotation colors");
    }

    @Override
    protected Void execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        File file = FileChooserUtil.showSaveDialog(UIUtil.getCurrentFrame(), null, null);
        if (file == null) {
            return null;
        }
        final Project project = (Project)map.get("project");
        new BlockingThread("Saving " + file.getName(), true){

            @Override
            public void doInBackground() throws Exception {
                VectorColorModel colorModel = project.getColumnColorModel();
                MetadataModel model = MetadataUtil.filter(project.getOriginalDataset().getColumnMetadata(), "Color Visible");
                Properties props = new Properties();
                int size = model.getMetadataCount();
                for (int i = 0; i < size; ++i) {
                    Vector vector = model.get(i);
                    if (colorModel.getContinuousColorScheme(vector) != null) continue;
                    Set values = VectorUtil.getValues(vector);
                    for (Object value : values) {
                        if (!colorModel.containsDiscreteColor(vector, value)) continue;
                        Color color = (Color)colorModel.getMappedValue(vector, value);
                        props.setProperty(vector.getName() + "." + value, ImageUtil.toString(color));
                    }
                }
            }
        };
        return null;
    }

    @Override
    protected void succeeded(Map<String, Object> map, MutableTreeNode activeNode, Void result) {
    }
}

