/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.visualization;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.chart.action.HistogramAction;
import org.broadinstitute.genee.chart.action.XYChartAction;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.venn.VennDiagramAction;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.GENEEResultNodeGroup;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class VisualizationMenu
extends JMenu {
    public VisualizationMenu(final HeatMapPanel heatMapPanel) {
        super("Visualization");
        this.add(new AbstractAction("Heat Map"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerUtil.trackPageView("Heat Map");
                ProjectGENEEResultTreeNode currentNode = (ProjectGENEEResultTreeNode)Application.getWindowManager().getNode();
                DefaultProject newProject = new DefaultProject(heatMapPanel.getProject().getOriginalDataset(), heatMapPanel.getProject());
                final GENEEResultNodeGroup group = new GENEEResultNodeGroup();
                group.setParentNode(currentNode);
                ProjectGENEEResultTreeNode childNode = new ProjectGENEEResultTreeNode(newProject, currentNode.getAuditTrail().getTrail().get(0));
                childNode.getDisplayInfo().getComponent().putClientProperty(GENEEResultNodeGroup.NO_SIZE_SYNC, true);
                GENEEWindow window = Application.createViewWindow("Heat Map - " + heatMapPanel.getProject().getOriginalDataset().getName(), new GENEEWindowNotifier(){

                    @Override
                    public void notifyShowing() {
                    }

                    @Override
                    public void notifyHidden() {
                        group.dispose();
                    }
                });
                group.addChild(childNode);
                window.getContentPane().add(childNode.getDisplayInfo().getComponent());
                window.pack();
                window.setVisible(true);
            }
        });
        this.add(new JSeparator());
        this.add(heatMapPanel.getHeatMapEditorKit().getDatasetTableViewAction());
        this.add(new JSeparator());
        this.add(new XYChartAction(false));
        this.add(new XYChartAction(true));
        this.add(new JSeparator());
        this.add(new HistogramAction());
        this.add(new JSeparator());
        this.add(heatMapPanel.getHeatMapEditorKit().getBoxPlotAction());
        this.add(new JSeparator());
        this.add(heatMapPanel.getHeatMapEditorKit().getColumnProfileAction());
        this.add(heatMapPanel.getHeatMapEditorKit().getRowProfileAction());
        this.add(new JSeparator());
        this.add(heatMapPanel.getHeatMapEditorKit().getRankedListAction());
        this.add(new JSeparator());
        this.add(new VennDiagramAction());
        if (heatMapPanel.getProject().getOriginalDataset().getRowCount() == 0) {
            UIUtil.setChildrenEnabledRecursively(this, false);
        }
    }
}

