/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.excel;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class AddToMetadataContentHandler
implements ExcelReaderContentHandler {
    private VectorColorModel colorModel;
    private Map<Integer, String> columnIndexToValue = new HashMap<Integer, String>();
    private boolean convertClass;
    private int[] headerColumnIndices;
    private Map<Integer, Integer> headerColumnIndexToMetadataColumnNameIndex;
    private String key;
    private int keyColumnIndex = 0;
    private Map<String, TIntArrayList> keyToIndices;
    private MetadataModel metadata;
    private int[] metadataColumnIndices;
    private String[] metadataColumnNames;
    private int rowIndex = -1;
    private boolean rows;

    public AddToMetadataContentHandler(MetadataModel metadata, VectorColorModel colorModel, int[] headerColumnIndices, Map<String, TIntArrayList> keyToIndices, boolean rows, boolean convertClass, int keyColumnIndex) {
        this.headerColumnIndices = headerColumnIndices;
        this.metadata = metadata;
        this.colorModel = colorModel;
        this.keyToIndices = keyToIndices;
        this.rows = rows;
        this.convertClass = convertClass;
        this.keyColumnIndex = keyColumnIndex;
    }

    public AddToMetadataContentHandler(MetadataModel metadata, VectorColorModel colorModel, int[] headerColumnIndices, Map<String, TIntArrayList> keyToIndices, boolean rows, int keyColumnIndex) {
        this(metadata, colorModel, headerColumnIndices, keyToIndices, rows, true, keyColumnIndex);
    }

    public AddToMetadataContentHandler(MetadataModel metadata, VectorColorModel colorModel, int[] headerColumnIndices, Map<String, TIntArrayList> keyToIndices, boolean rows) {
        this(metadata, colorModel, headerColumnIndices, keyToIndices, rows, true, 0);
    }

    @Override
    public void color(int columnIndex, String value, Color color) {
        Integer tmp = this.headerColumnIndexToMetadataColumnNameIndex.get(columnIndex);
        if (tmp == null) {
            return;
        }
        columnIndex = tmp;
        String columnName = this.metadataColumnNames[columnIndex];
        int metadataColumnIndex = this.metadata.getColumnIndex(columnName);
        if (metadataColumnIndex != -1 && this.colorModel != null) {
            Vector v = this.metadata.get(metadataColumnIndex);
            this.colorModel.setMappedValue(v, value, color);
        }
    }

    @Override
    public void end() {
        this.addRowValues();
        if (this.convertClass && this.metadataColumnIndices != null) {
            for (int columnIndex : this.metadataColumnIndices) {
                MetadataUtil.maybeConvertMetadataClass(this.metadata, this.colorModel, true, columnIndex, this.rows);
            }
        }
    }

    public Collection<String> getMetadataColumnNames() {
        return Arrays.asList(this.metadataColumnNames);
    }

    @Override
    public void init(int rows, int columns) {
        if (this.headerColumnIndices == null) {
            TIntArrayList tmp = new TIntArrayList();
            for (int i = 0; i < columns; ++i) {
                if (i == this.keyColumnIndex) continue;
                tmp.add(i);
            }
            this.headerColumnIndices = tmp.toArray();
        }
        this.headerColumnIndexToMetadataColumnNameIndex = new HashMap<Integer, Integer>();
        int length = this.headerColumnIndices.length;
        for (int i = 0; i < length; ++i) {
            this.headerColumnIndexToMetadataColumnNameIndex.put(this.headerColumnIndices[i], i);
        }
        this.metadataColumnNames = new String[this.headerColumnIndices.length];
    }

    @Override
    public boolean nextRow() {
        this.addRowValues();
        if (this.rowIndex == 0) {
            int j;
            this.metadataColumnIndices = new int[this.metadataColumnNames.length];
            for (j = 0; j < this.metadataColumnNames.length; ++j) {
                Vector v;
                if (this.rows) {
                    if (this.metadataColumnNames.length < 20) {
                        MetadataUtil.addRowVector(this.metadata, this.metadataColumnNames[j], String.class);
                        continue;
                    }
                    v = this.metadata.add(this.metadataColumnNames[j], String.class);
                    v.setProperty("Tooltip Visible", true);
                    continue;
                }
                if (this.metadataColumnNames.length < 20) {
                    MetadataUtil.addColumnVector(this.metadata, this.metadataColumnNames[j], String.class);
                    continue;
                }
                v = this.metadata.add(this.metadataColumnNames[j], String.class);
                v.setProperty("Tooltip Visible", true);
            }
            for (j = 0; j < this.metadataColumnNames.length; ++j) {
                int index = this.metadata.getColumnIndex(this.metadataColumnNames[j]);
                if (index == -1) {
                    throw new RuntimeException();
                }
                this.metadataColumnIndices[j] = index;
            }
        }
        ++this.rowIndex;
        return true;
    }

    @Override
    public void value(int columnIndex, String s) {
        if (columnIndex == this.keyColumnIndex) {
            this.key = s;
        } else {
            this.columnIndexToValue.put(columnIndex, s);
        }
    }

    private void addRowValues() {
        for (Integer columnIndex : this.columnIndexToValue.keySet()) {
            Integer tmp = this.headerColumnIndexToMetadataColumnNameIndex.get(columnIndex);
            if (tmp == null) {
                return;
            }
            String s = this.columnIndexToValue.get(columnIndex);
            columnIndex = tmp;
            if (this.rowIndex == 0) {
                this.metadataColumnNames[columnIndex.intValue()] = s;
                continue;
            }
            TIntArrayList indices = this.keyToIndices.get(this.key);
            if (indices == null) continue;
            int nIndices = indices.size();
            for (int i = 0; i < nIndices; ++i) {
                this.metadata.setValue(indices.getQuick(i), this.metadataColumnIndices[columnIndex], (Object)s);
            }
        }
        this.columnIndexToValue.clear();
    }
}

