/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.excel;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;

public class ColumnMajorContentHandler
implements ExcelReaderContentHandler {
    private Map<MatrixElement, Color> colors;
    private List<String>[] columns;
    private int rowIndex = -1;
    private Map<Integer, Integer> columnIndicesToInclude;
    private Set<String> columnNames;

    public ColumnMajorContentHandler() {
    }

    public ColumnMajorContentHandler(Set<String> columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public void color(int c, String value, Color bg) {
        this.colors.put(new MatrixElement(this.rowIndex, c), bg);
    }

    @Override
    public void end() {
        int rowsToRemove = 0;
        if (this.columns != null) {
            for (int rowIndex = this.columns[0].size() - 1; rowIndex >= 0; --rowIndex) {
                boolean rowEmpty = true;
                int ncols = this.columns.length;
                for (int j = 0; j < ncols; ++j) {
                    String val;
                    String string = val = rowIndex < this.columns[j].size() ? this.columns[j].get(rowIndex) : null;
                    if (val == null || val.equals("")) continue;
                    rowEmpty = false;
                }
                if (!rowEmpty) break;
                ++rowsToRemove;
            }
            if (rowsToRemove > 0) {
                System.out.println("Removing " + rowsToRemove + " rows.");
                for (int i = 0; i < rowsToRemove; ++i) {
                    for (int j = 0; j < this.columns.length; ++j) {
                        this.columns[j].remove(this.columns[j].size() - 1);
                    }
                }
            }
        }
    }

    public Map<MatrixElement, Color> getBackgroundColors() {
        return this.colors;
    }

    public List<String>[] getColumns() {
        return this.columns;
    }

    @Override
    public void init(int rows, int columns) {
        if (this.columnNames == null) {
            this.columns = new List[columns];
        } else {
            this.columnIndicesToInclude = new HashMap<Integer, Integer>();
            this.columns = new List[this.columnNames.size()];
        }
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = new ArrayList<String>();
        }
        this.colors = new HashMap<MatrixElement, Color>();
    }

    @Override
    public boolean nextRow() {
        ++this.rowIndex;
        return true;
    }

    @Override
    public void value(int columnIndex, String text) {
        if (this.rowIndex == 0 && this.columnNames != null && this.columnNames.contains(text)) {
            this.columnIndicesToInclude.put(columnIndex, this.columnIndicesToInclude.size());
        }
        if (this.columnIndicesToInclude == null) {
            this.columns[columnIndex].add(text);
        } else {
            Integer mappedIndex = this.columnIndicesToInclude.get(columnIndex);
            if (mappedIndex != null) {
                this.columns[mappedIndex].add(text);
            }
        }
    }
}

