/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.geo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.io.util.IOUtil;

public class GEOPlatformParser {
    private Map<String, String> idToSymbol;
    private String species;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GEOPlatformParser(String file) throws IOException {
        try (BufferedReader br = null;){
            String s;
            br = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)));
            int rows = 0;
            while ((s = br.readLine()) != null) {
                if (s.startsWith("!Platform_data_row_count")) {
                    rows = Integer.parseInt(s.substring(s.indexOf(61) + 1).trim());
                    continue;
                }
                if (s.startsWith("!Platform_organism")) {
                    this.species = s.substring(s.indexOf(61) + 1).trim();
                    continue;
                }
                if (!s.startsWith("!platform_table_begin")) continue;
            }
            String header = br.readLine();
            List<String> platformHeaders = Arrays.asList(IOUtil.split(header));
            int geneSymbolIndex = -1;
            int size = platformHeaders.size();
            for (int i = 0; i < size; ++i) {
                String field = platformHeaders.get(i).toLowerCase();
                if (!field.contains("gene") || !field.contains("symbol")) continue;
                geneSymbolIndex = i;
                break;
            }
            boolean multipart = false;
            if (geneSymbolIndex == -1) {
                geneSymbolIndex = platformHeaders.indexOf("gene_assignment");
                multipart = true;
            }
            if (geneSymbolIndex == -1) {
                String[] fieldNameContains = new String[]{"symbol", "hugo", "gene"};
                block5: for (int j = 0; j < fieldNameContains.length && geneSymbolIndex == -1; ++j) {
                    String geneSymbolField = fieldNameContains[j];
                    int size2 = platformHeaders.size();
                    for (int i = 0; i < size2; ++i) {
                        String platformField = platformHeaders.get(i).toLowerCase();
                        if (!platformField.contains(geneSymbolField)) continue;
                        geneSymbolIndex = i;
                        continue block5;
                    }
                }
            }
            if (geneSymbolIndex == -1) {
                throw new IOException("Gene symbol not found for " + file + ". Headers are " + platformHeaders);
            }
            String[] tokens = new String[platformHeaders.size()];
            int idIndex = 0;
            this.idToSymbol = new HashMap<String, String>();
            for (int i = 0; i < rows; ++i) {
                int index2;
                int index1;
                s = br.readLine();
                IOUtil.split(s, tokens, '\t');
                String symbol = tokens[geneSymbolIndex].toUpperCase();
                if (multipart && (index1 = symbol.indexOf("//")) != -1 && (index2 = symbol.indexOf("//", index1 + 1)) != -1) {
                    symbol = symbol.substring(index1 + 2, index2).trim();
                }
                this.idToSymbol.put(tokens[idIndex], symbol);
            }
        }
    }

    public Map<String, String> getIdToSymbol() {
        return this.idToSymbol;
    }

    public String getSpecies() {
        return this.species;
    }
}

