/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.geo;

import com.google.common.collect.HashBasedTable;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class GEOSeriesParser {
    private BufferedReader br;
    private Dataset dataset;
    private String file;
    private String[] platformHeaders;
    private String[] rowIds;
    private Map<String, Integer> rowIdToIndex;
    private String[] sampleIds;
    private HashMap<String, Integer> sampleIdToIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GEOSeriesParser(String file, boolean headerOnly) throws IOException {
        try {
            this.file = file;
            this.br = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)));
            this.parsePlatformTable(IOUtil.getName(file));
            if (!headerOnly) {
                while (this.parseSamples()) {
                }
            }
        }
        catch (SoftException e) {
            this.parseMalformed();
        }
        finally {
            this.close();
        }
    }

    public Project createProject() {
        DefaultProject p = new DefaultProject(this.dataset);
        return p;
    }

    public String[] getSampleIds() {
        return this.sampleIds;
    }

    private void close() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void parseMalformed() throws IOException {
        int i;
        int length;
        String s;
        this.close();
        this.br = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(this.file)));
        while ((s = this.br.readLine()) != null && ((s = s.trim()).length() <= 0 || s.charAt(0) == '!' || s.charAt(0) == '#' || s.charAt(0) == '^')) {
        }
        String header = s;
        List<String> tokens = Arrays.asList(IOUtil.split(header));
        LinkedHashSet<String> columnFields = new LinkedHashSet<String>(Arrays.asList("CELL_LINE", "CELL_LINEAGE", "CellsPerWell", "CultureMedia"));
        TIntArrayList columnIndices = new TIntArrayList();
        for (String field : columnFields) {
            int index = tokens.indexOf(field);
            if (index == -1) continue;
            columnIndices.add(index);
        }
        LinkedHashSet<String> rowFields = new LinkedHashSet<String>(Arrays.asList("CPD_NAME", "BROAD_CPD_ID", "SMILES"));
        TIntArrayList rowIndices = new TIntArrayList();
        for (String field : rowFields) {
            int index = tokens.indexOf(field);
            if (index == -1) continue;
            rowIndices.add(index);
        }
        String value = "AUC";
        int valueIndex = tokens.indexOf(value);
        HashBasedTable table = HashBasedTable.create();
        while ((s = this.br.readLine()) != null) {
            s = s.trim();
            String[] line = IOUtil.split(s);
            String[] columnId = new String[columnIndices.size()];
            int size = columnIndices.size();
            for (int i2 = 0; i2 < size; ++i2) {
                int index = columnIndices.getQuick(i2);
                if (index >= line.length) continue;
                columnId[i2] = line[index];
            }
            String[] rowId = new String[rowIndices.size()];
            int size2 = rowIndices.size();
            for (int i3 = 0; i3 < size2; ++i3) {
                int index = rowIndices.getQuick(i3);
                if (index >= line.length) continue;
                rowId[i3] = line[index];
            }
            Identifier<String> r = new Identifier<String>(rowId);
            Identifier<String> c = new Identifier<String>(columnId);
            if (valueIndex >= line.length) continue;
            try {
                float val = ParserHelper.parseFloatNaN(line[valueIndex]);
                table.put(r, c, (Object)Float.valueOf(val));
            }
            catch (Exception x) {}
        }
        Set rows = table.rowKeySet();
        Set columns = table.columnKeySet();
        this.dataset = new RowMajorArray2DDataset(IOUtil.getBaseFileName(this.file), rows.size(), columns.size());
        DatasetUtil.fill(this.dataset, Float.NaN);
        int size = rowIndices.size();
        for (int i4 = 0; i4 < size; ++i4) {
            MetadataUtil.addRowVector(this.dataset.getRowMetadata(), tokens.get(rowIndices.getQuick(i4)), String.class);
        }
        int counter = 0;
        for (Identifier id : rows) {
            T[] array = id.getArray();
            length = array.length;
            for (i = 0; i < length; ++i) {
                this.dataset.getRowMetadata().get(i).setValue(counter, array[i]);
            }
            ++counter;
        }
        int size3 = columnIndices.size();
        for (int i5 = 0; i5 < size3; ++i5) {
            MetadataUtil.addRowVector(this.dataset.getColumnMetadata(), tokens.get(columnIndices.getQuick(i5)), String.class);
        }
        counter = 0;
        for (Identifier id : columns) {
            T[] array = id.getArray();
            length = array.length;
            for (i = 0; i < length; ++i) {
                this.dataset.getColumnMetadata().get(i).setValue(counter, array[i]);
            }
            ++counter;
        }
        int row = 0;
        for (Identifier rowId : rows) {
            int col = 0;
            for (Identifier columnId : columns) {
                Float val = (Float)table.get((Object)rowId, (Object)columnId);
                this.dataset.setValue(row, col, val == null ? Float.NaN : val.floatValue());
                ++col;
            }
            ++row;
        }
    }

    private void parsePlatformTable(String name) throws SoftException, IOException {
        int i;
        int i2;
        String s;
        ArrayList<String> sampleIdList = new ArrayList<String>();
        int rows = -1;
        while ((s = this.br.readLine()) != null) {
            if (s.startsWith("!Platform_data_row_count")) {
                rows = Integer.parseInt(s.substring(s.indexOf(61) + 1).trim());
                continue;
            }
            if (s.startsWith("!Series_sample_id")) {
                String sampleId = s.substring(s.indexOf(61) + 1).trim();
                sampleIdList.add(sampleId);
                continue;
            }
            if (!s.startsWith("!platform_table_begin")) continue;
        }
        if (rows == -1) {
            throw new SoftException();
        }
        this.sampleIds = new String[sampleIdList.size()];
        this.sampleIdToIndex = new HashMap();
        int cols = sampleIdList.size();
        for (int j = 0; j < cols; ++j) {
            String id;
            this.sampleIds[j] = id = (String)sampleIdList.get(j);
            this.sampleIdToIndex.put(id, j);
        }
        String header = this.br.readLine();
        if (header == null) {
            throw new NullPointerException("platform_table_begin not found");
        }
        this.platformHeaders = IOUtil.split(header);
        String[] tokens = new String[this.platformHeaders.length];
        this.rowIds = new String[rows];
        for (i2 = 0; i2 < rows; ++i2) {
            s = this.br.readLine();
            IOUtil.split(s, tokens, '\t');
            this.rowIds[i2] = tokens[0];
        }
        this.rowIdToIndex = new HashMap<String, Integer>();
        int size = this.rowIds.length;
        for (i2 = 0; i2 < size; ++i2) {
            this.rowIdToIndex.put(this.rowIds[i2], i2);
        }
        this.dataset = new RowMajorArray2DDataset(name, this.rowIds.length, this.sampleIds.length);
        DatasetUtil.fill(this.dataset, Float.NaN);
        Vector v = MetadataUtil.addRowVector(this.dataset.getRowMetadata(), "id", String.class);
        int nrows = this.dataset.getRowCount();
        for (i = 0; i < nrows; ++i) {
            v.setValue(i, this.rowIds[i]);
        }
        v = MetadataUtil.addRowVector(this.dataset.getColumnMetadata(), "id", String.class);
        int ncols = this.dataset.getColumnCount();
        for (i = 0; i < ncols; ++i) {
            v.setValue(i, this.sampleIds[i]);
        }
    }

    private boolean parseSamples() throws IOException {
        String s;
        boolean sampleFound = false;
        while ((s = this.br.readLine()) != null) {
            if (!s.startsWith("^SAMPLE")) continue;
            sampleFound = true;
            break;
        }
        if (!sampleFound) {
            return false;
        }
        if (s == null) {
            throw new NullPointerException("Sample id not found.");
        }
        String sampleId = s.substring(s.indexOf(61) + 1).trim();
        int sampleColumnIndex = this.sampleIdToIndex.get(sampleId);
        MetadataModel columnMetadata = this.dataset.getColumnMetadata();
        while (!(s = this.br.readLine()).startsWith("!sample_table_begin")) {
            int cIndex;
            Vector vector;
            String text;
            if (s.startsWith("!Sample_description")) {
                text = s.substring(s.indexOf(61) + 1);
                String category = "description";
                vector = columnMetadata.get(category);
                if (vector == null) {
                    vector = MetadataUtil.addColumnVector(columnMetadata, category, String.class);
                }
                vector.setValue(sampleColumnIndex, text);
                continue;
            }
            if (s.startsWith("!Sample_title")) {
                text = s.substring(s.indexOf(61) + 1);
                String category = "title";
                vector = columnMetadata.get(category);
                if (vector == null) {
                    vector = MetadataUtil.addColumnVector(columnMetadata, category, String.class);
                }
                vector.setValue(sampleColumnIndex, text);
                continue;
            }
            if (!s.startsWith("!Sample_characteristics") || (cIndex = (text = s.substring(s.indexOf(61) + 1)).indexOf(58)) == -1) continue;
            String category = text.substring(0, cIndex).trim();
            Vector vector2 = columnMetadata.get(category);
            if (vector2 == null) {
                vector2 = MetadataUtil.addColumnVector(columnMetadata, category, String.class);
            }
            String value = text.substring(cIndex).trim();
            vector2.setValue(sampleColumnIndex, value);
        }
        String sampleTableHeader = this.br.readLine();
        String[] header = IOUtil.split(sampleTableHeader);
        String[] tokens = new String[header.length];
        int rows = this.dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            s = this.br.readLine();
            IOUtil.split(s, tokens, '\t');
            String rowId = tokens[0];
            Integer rowIndex = this.rowIdToIndex.get(rowId);
            if (rowId.equals("!sample_table_end")) break;
            if (rowIndex == null) {
                throw new IOException("Identifier " + rowId + " not found.");
            }
            this.dataset.setValue(rowIndex, sampleColumnIndex, ParserHelper.parseFloatNaN(tokens[1]));
        }
        return true;
    }

    private String trim(String s) {
        int st;
        int len = s.length();
        for (st = 0; st < len && s.charAt(st) <= ' '; ++st) {
        }
        while (st < len && s.charAt(len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < s.length() ? s.substring(st, len) : s;
    }

    private static class SoftException
    extends Exception {
        private SoftException() {
        }
    }
}

