/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.magetab;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.genee.io.util.IOUtil;

public class SdrfReader {
    public static List<String[]> read(String file) throws IOException {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        try (BufferedReader br = IOUtil.getBufferedReader(file);){
            String s;
            int index2;
            int index;
            String name;
            String header;
            int i;
            String[] headerTokens = br.readLine().split("\t");
            TIntArrayList indices = new TIntArrayList();
            HashSet<String> names = new HashSet<String>();
            int n = headerTokens.length;
            for (i = 0; i < n; ++i) {
                header = headerTokens[i];
                if ((!header.startsWith("Characteristics") || header.contains("BioSourceProvider")) && !header.startsWith("Factor Value") && !header.startsWith("Sample Name") && !header.startsWith("Scan Name") && !header.startsWith("FactorValue") || names.contains((name = header).toLowerCase())) continue;
                index = name.indexOf(91);
                if (index != -1 && (index2 = name.indexOf(93)) != -1) {
                    name = name.substring(index + 1, index2);
                }
                if (names.contains(name.toLowerCase())) continue;
                names.add(name.toLowerCase());
                headerTokens[i] = name;
                indices.add(i);
            }
            n = headerTokens.length;
            for (i = 0; i < n; ++i) {
                header = headerTokens[i];
                if (!header.startsWith("Comment") || (index = (name = header).indexOf(91)) == -1 || (index2 = name.indexOf(93)) == -1 || !"Sample_description".equals(name = name.substring(index + 1, index2)) && !"Sample_source_name".equals(name) || names.contains(name.toLowerCase())) continue;
                headerTokens[i] = name;
                indices.add(i);
                names.add(name.toLowerCase());
            }
            int[] columns = indices.toArray();
            String[] tokens = new String[headerTokens.length];
            String[] columnNames = new String[columns.length];
            int n2 = columns.length;
            for (int j = 0; j < n2; ++j) {
                columnNames[j] = headerTokens[columns[j]];
            }
            lines.add(columnNames);
            while ((s = br.readLine()) != null) {
                IOUtil.split(s, tokens, '\t');
                String[] line = new String[columns.length];
                int n3 = columns.length;
                for (int j = 0; j < n3; ++j) {
                    String val;
                    line[j] = val = tokens[columns[j]];
                }
                lines.add(line);
            }
            int sampleNameIndex = Arrays.asList((Object[])lines.get(0)).indexOf("Sample Name");
            if (sampleNameIndex != -1) {
                int size = lines.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    String[] line = (String[])lines.get(i2);
                    String val = line[sampleNameIndex];
                    if (!val.startsWith("GSE")) continue;
                    int index1 = val.indexOf("GSM");
                    int index22 = val.length();
                    if (val.endsWith(" sample")) {
                        index22 -= " sample".length();
                    }
                    line[sampleNameIndex] = val = val.substring(index1, index22);
                }
            }
        }
        return lines;
    }
}

