/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import java.util.List;

public class MafHeader {
    public int contig;
    public int covered;
    public int Genome_Change;
    public int Hugo_Symbol;
    public int judgement;
    public int n_alt_count;
    public int n_ref_count;
    public int normal_name;
    public int position;
    public int Protein_Change;
    public int Start_Position;
    public int t_alt_count;
    public int t_ref_count;
    public int tumor_f;
    public int tumor_name;
    public int Variant_Classification;
    public int t_q20_count;

    public MafHeader(List<String> header) {
        this.tumor_name = MafHeader.indexOf(header, "tumor_name");
        this.normal_name = MafHeader.indexOf(header, "normal_name");
        this.contig = MafHeader.indexOf(header, "contig");
        this.position = MafHeader.indexOf(header, "position");
        this.judgement = MafHeader.indexOf(header, "judgement");
        this.Hugo_Symbol = MafHeader.indexOf(header, "Hugo_Symbol");
        this.Genome_Change = MafHeader.indexOf(header, "Genome_Change");
        this.tumor_f = MafHeader.indexOf(header, "tumor_f");
        this.covered = MafHeader.indexOf(header, "covered");
        this.t_ref_count = MafHeader.indexOf(header, "t_ref_count");
        this.t_alt_count = MafHeader.indexOf(header, "t_alt_count");
        this.n_ref_count = MafHeader.indexOf(header, "n_ref_count");
        this.n_alt_count = MafHeader.indexOf(header, "n_alt_count");
        this.Protein_Change = MafHeader.indexOf(header, "Protein_Change");
        this.Variant_Classification = MafHeader.indexOf(header, "Variant_Classification");
        this.Start_Position = MafHeader.indexOf(header, "Start_Position");
        this.t_q20_count = MafHeader.indexOf(header, "t_q20_count");
    }

    private static int indexOf(List<String> header, String field) {
        int size = header.size();
        for (int i = 0; i < size; ++i) {
            if (!field.equalsIgnoreCase(header.get(i))) continue;
            return i;
        }
        return -1;
    }
}

