/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;

public class RefSeq {
    private List<RefSeqEntry> entries = new ArrayList<RefSeqEntry>();
    private List<RefSeqFile> files = new ArrayList<RefSeqFile>();

    public List<RefSeqEntry> getEntries() {
        return this.entries;
    }

    public void read() throws IOException {
        for (RefSeqFile f : this.files) {
            this.read(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGeneAnnotationsFile(String outputFile) throws IOException {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            pw.println("Name\tChromosome\tStrand\tLocation Start\tLocation End");
            for (RefSeqEntry e : this.entries) {
                pw.print(e.gene);
                pw.print("\t");
                pw.print(e.chromosome);
                pw.print("\t");
                pw.print(e.strand);
                pw.print("\t");
                pw.print(e.start);
                pw.print("\t");
                pw.print(e.end);
                pw.println();
            }
        }
    }

    private void addFile(RefSeqFile f) {
        this.files.add(f);
    }

    private void read(RefSeqFile rf) throws IOException {
        String file = rf.file;
        int chromosomeColumnIndex = rf.chromosomeColumnIndex;
        int nameColumnIndex = rf.nameColumnIndex;
        int startColumnIndex = rf.startColumnIndex;
        int endColumnIndex = rf.endColumnIndex;
        int strandColumnIndex = rf.strandColumnIndex;
        Array2DContentHandler handler = new Array2DContentHandler();
        new ExcelReader(file, handler);
        for (String[] array : handler.getData()) {
            int chromosome;
            String chr = array[chromosomeColumnIndex];
            int underscore = (chr = chr.substring(3)).indexOf(95);
            if (underscore != -1) {
                chr = chr.substring(0, underscore);
            }
            if (chr.equals("X")) {
                chromosome = 23;
            } else if (chr.equals("Y")) {
                chromosome = 24;
            } else {
                if (chr.equals("Un") || chr.equals("M")) continue;
                chromosome = Integer.parseInt(chr);
            }
            String gene = array[nameColumnIndex];
            int start = Integer.parseInt(array[startColumnIndex]);
            int end = Integer.parseInt(array[endColumnIndex]);
            String strand = array[strandColumnIndex];
            this.entries.add(new RefSeqEntry(start, end, chromosome, gene, strand));
        }
    }

    public static RefSeq getDefaultInstance() throws IOException {
        RefSeq rf = new RefSeq();
        rf.addFile(new RefSeqFile("/Users/jgould/datasets/wgRna.txt", 1, 6, 2, 3, 4));
        rf.addFile(new RefSeqFile("/Users/jgould/datasets/refFlat.txt", 2, 3, 4, 5, 0));
        rf.read();
        return rf;
    }

    public static void main(String[] args) throws IOException {
        RefSeq.getDefaultInstance().writeGeneAnnotationsFile("/Users/jgould/datasets/refseq-annotations.txt");
    }

    public static class RefSeqFile {
        private String file;
        private int chromosomeColumnIndex;
        private int strandColumnIndex;
        private int startColumnIndex;
        private int endColumnIndex;
        private int nameColumnIndex;

        public RefSeqFile(String file, int chromosomeColumnIndex, int strandColumnIndex, int startColumnIndex, int endColumnIndex, int nameColumnIndex) {
            this.file = file;
            this.chromosomeColumnIndex = chromosomeColumnIndex;
            this.strandColumnIndex = strandColumnIndex;
            this.startColumnIndex = startColumnIndex;
            this.endColumnIndex = endColumnIndex;
            this.nameColumnIndex = nameColumnIndex;
        }
    }

    public static class RefSeqEntry {
        public int start;
        public int end;
        public int chromosome;
        public String gene;
        public String strand;

        public RefSeqEntry(int start, int end, int chromosome, String gene, String strand) {
            this.start = start;
            this.end = end;
            this.chromosome = chromosome;
            this.gene = gene;
            this.strand = strand;
        }
    }
}

