/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import gnu.trove.list.array.TFloatArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class RnkReader
implements ProjectReader {
    private List<String> suffixes = Collections.unmodifiableList(Arrays.asList("rnk"));

    @Override
    public List<String> getFileSuffixes() {
        return this.suffixes;
    }

    @Override
    public String getFormatName() {
        return "rnk";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project read(String file) throws IOException {
        try (InputStream is = null;){
            is = IOUtil.getInputStream(file);
            DefaultProject defaultProject = new DefaultProject(this.read(IOUtil.getName(file), is));
            return defaultProject;
        }
    }

    public Dataset read(String datasetName, InputStream is) throws IOException {
        String s;
        BufferedReader br = new BufferedReader(new InputStreamReader(is), 0x100000);
        ArrayList<String> names = new ArrayList<String>();
        TFloatArrayList values = new TFloatArrayList();
        String[] tokens = new String[2];
        while ((s = br.readLine()) != null) {
            if ((s = s.trim()).startsWith("#")) continue;
            IOUtil.split(s, tokens, '\t');
            names.add(tokens[0]);
            values.add(ParserHelper.parseFloatNaN(tokens[1]));
        }
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(datasetName, values.size(), 1);
        MetadataUtil.addRowVector(dataset.getColumnMetadata(), "id", String.class).setValue(0, datasetName);
        Vector rowIds = MetadataUtil.addRowVector(dataset.getRowMetadata(), "id", String.class);
        int nrows = names.size();
        for (int i = 0; i < nrows; ++i) {
            rowIds.setValue(i, names.get(i));
            dataset.setValue(i, 0, values.getQuick(i));
        }
        return dataset;
    }
}

