/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.matrix.RefSeq;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class SegToH5 {
    private List<RefSeq.RefSeqEntry> entries = RefSeq.getDefaultInstance().getEntries();

    public void segToMatrix(String segFile) throws IOException {
        Array2DContentHandler handler = new Array2DContentHandler();
        new ExcelReader(segFile, handler);
        String[][] seg = handler.getData();
        HashMap<String, Integer> sampleNameToIndex = new HashMap<String, Integer>();
        HashMap<String, Integer> geneNameToIndex = new HashMap<String, Integer>();
        int length = seg.length;
        for (int i = 1; i < length; ++i) {
            String sample = seg[i][0];
            if (!sampleNameToIndex.containsKey(sample)) {
                sampleNameToIndex.put(sample, sampleNameToIndex.size());
            }
            int start = Integer.parseInt(seg[i][2]);
            int end = Integer.parseInt(seg[i][3]);
            String chr = seg[i][1];
            int chromosome = chr.equals("X") ? 23 : (chr.equals("Y") ? 24 : Integer.parseInt(chr));
            Collection<String> genes = this.getGenes(chromosome, start, end);
            if (genes.size() <= 0) continue;
            for (String gene : genes) {
                if (geneNameToIndex.containsKey(gene)) continue;
                geneNameToIndex.put(gene, geneNameToIndex.size());
            }
        }
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset("", geneNameToIndex.size(), sampleNameToIndex.size());
        Vector rowIds = MetadataUtil.addRowVector(dataset.getRowMetadata(), "id", String.class);
        for (String gene : geneNameToIndex.keySet()) {
            rowIds.setValue((Integer)geneNameToIndex.get(gene), gene);
        }
        Vector columnIds = dataset.getColumnMetadata().add("id", String.class);
        for (String sample : sampleNameToIndex.keySet()) {
            columnIds.setValue((Integer)sampleNameToIndex.get(sample), sample);
        }
        int length2 = seg.length;
        for (int i = 1; i < length2; ++i) {
            String sample = seg[i][0];
            int columnIndex = (Integer)sampleNameToIndex.get(sample);
            int start = Integer.parseInt(seg[i][2]);
            int end = Integer.parseInt(seg[i][3]);
            String chr = seg[i][1];
            int chromosome = chr.equals("X") ? 23 : (chr.equals("Y") ? 24 : Integer.parseInt(chr));
            float ratio = ParserHelper.parseFloat(seg[i][5]);
            Collection<String> genes = this.getGenes(chromosome, start, end);
            if (genes.size() <= 0) continue;
            for (String gene : genes) {
                int rowIndex = (Integer)geneNameToIndex.get(gene);
                dataset.setValue(rowIndex, columnIndex, ratio);
            }
        }
        ProjectIO.writeProject((Project)new DefaultProject(dataset), "h5", segFile, true);
    }

    private Collection<String> getGenes(int chromosome, int start, int end) {
        TreeSet<String> genes = new TreeSet<String>();
        for (RefSeq.RefSeqEntry interval : this.entries) {
            if (chromosome != interval.chromosome || interval.start < start || interval.end > end) continue;
            genes.add(interval.gene);
        }
        return genes;
    }

    public static void main(String[] args) throws IOException {
        String segFile = "/Users/jgould/datasets/Tumorscape/tumorscape_100217.seg";
        SegToH5 s = new SegToH5();
        s.segToMatrix(segFile);
    }
}

