/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import java.io.IOException;
import java.io.PrintWriter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectWriter;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class TableauProjectWriter
implements ProjectWriter {
    private boolean rowMajorOrder = true;
    public static final String FORMAT_NAME = "Tableau";

    @Override
    public String checkFileExtension(String filename) {
        String ext = filename.toLowerCase();
        if (!ext.endsWith(".txt") && !ext.endsWith(".tab")) {
            filename = filename + ".tsv";
        }
        return filename;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Project project, PrintWriter pw) throws IOException {
        String na = Formatter.getNaN();
        Formatter.setNaN("Null");
        try {
            int i;
            Dataset dataset = project.getSortedFilteredDataset();
            if (!this.rowMajorOrder) {
                dataset = DatasetUtil.transposeView(dataset);
            }
            int nseries = dataset.getSeriesCount();
            for (i = 0; i < nseries; ++i) {
                if (i > 0) {
                    pw.print("\t");
                }
                pw.print(dataset.getSeriesName(i));
            }
            int metadataCount = dataset.getRowMetadata().getMetadataCount();
            for (i = 0; i < metadataCount; ++i) {
                pw.print("\t");
                pw.print(dataset.getRowMetadata().getColumnName(i));
            }
            metadataCount = dataset.getColumnMetadata().getMetadataCount();
            for (i = 0; i < metadataCount; ++i) {
                pw.print("\t");
                pw.print(dataset.getColumnMetadata().getColumnName(i));
            }
            pw.println();
            int nrows = dataset.getRowCount();
            for (i = 0; i < nrows; ++i) {
                int ncols = dataset.getColumnCount();
                for (int j = 0; j < ncols; ++j) {
                    int k;
                    int nseries2 = dataset.getSeriesCount();
                    for (k = 0; k < nseries2; ++k) {
                        if (k > 0) {
                            pw.print("\t");
                        }
                        pw.print(Formatter.toString(dataset.getObjectValue(i, j, k)));
                    }
                    int metadataCount2 = dataset.getRowMetadata().getMetadataCount();
                    for (k = 0; k < metadataCount2; ++k) {
                        pw.print("\t");
                        pw.print(Formatter.toString(dataset.getRowMetadata().getValue(i, k)));
                    }
                    metadataCount2 = dataset.getColumnMetadata().getMetadataCount();
                    for (k = 0; k < metadataCount2; ++k) {
                        pw.print("\t");
                        pw.print(Formatter.toString(dataset.getColumnMetadata().getValue(j, k)));
                    }
                    pw.println();
                }
            }
        }
        finally {
            Formatter.setNaN(na);
        }
    }
}

