/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.dchip;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class DChipReader
implements ProjectReader {
    @Override
    public List<String> getFileSuffixes() {
        return Collections.unmodifiableList(Arrays.asList("dchip", "txt"));
    }

    @Override
    public String getFormatName() {
        return "dchip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project read(String file) throws IOException {
        try (BufferedReader reader = null;){
            String[] headerTokens;
            reader = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)));
            String line = reader.readLine();
            if (line.trim().toLowerCase().startsWith("[dchip")) {
                while (!(line = reader.readLine().trim()).equalsIgnoreCase("[data]")) {
                }
            }
            if ((headerTokens = IOUtil.split(line)) == null || headerTokens.length == 0 || headerTokens.length == 1) {
                throw new IOException("Unable to parse line 1");
            }
            int columns = headerTokens.length - 1;
            if (columns <= 0) {
                throw new IOException("Number of samples must be greater than zero");
            }
            int dataColumnIdxBegin = 1;
            String[] columnNames = new String[headerTokens.length - dataColumnIdxBegin];
            int i = dataColumnIdxBegin;
            int columnIndex = 0;
            while (i < headerTokens.length) {
                columnNames[columnIndex] = headerTokens[i];
                ++i;
                ++columnIndex;
            }
            String s = null;
            ArrayList<String> rowNames = new ArrayList<String>();
            ArrayList<float[]> dataList = new ArrayList<float[]>();
            int lineNumber = 0;
            while ((s = reader.readLine()) != null) {
                int expectedTokens;
                if (s.equals("")) continue;
                String[] tokens = IOUtil.split(s);
                int numTokens = tokens.length;
                if (numTokens != (expectedTokens = columns + 1)) {
                    throw new IOException("Incomplete data on line " + lineNumber + ". Expected " + expectedTokens + ", got " + numTokens + " tokens.");
                }
                String rowName = tokens[0];
                rowNames.add(new String(rowName));
                float[] array = new float[columns];
                int columnIndex2 = 0;
                int tokenIndex = dataColumnIdxBegin;
                while (columnIndex2 < columns) {
                    try {
                        float data;
                        array[columnIndex2] = data = ParserHelper.parseFloatNaN(tokens[tokenIndex]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("Data at line number " + lineNumber + " and column " + columnIndex2 + " is not a number.");
                    }
                    ++columnIndex2;
                    ++tokenIndex;
                }
                dataList.add(array);
                ++lineNumber;
            }
            float[][] array = new float[dataList.size()][];
            int size = dataList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                array[i2] = (float[])dataList.get(i2);
            }
            RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(IOUtil.getName(file), array);
            Vector columnIds = dataset.getColumnMetadata().add("id", String.class);
            int ncols = columnIds.size();
            for (int j = 0; j < ncols; ++j) {
                columnIds.setValue(j, columnNames[j]);
            }
            Vector rowIds = dataset.getRowMetadata().add("id", String.class);
            int ncols2 = rowIds.size();
            for (int i3 = 0; i3 < ncols2; ++i3) {
                rowIds.setValue(i3, rowNames.get(i3));
            }
            DefaultProject defaultProject = new DefaultProject(dataset);
            return defaultProject;
        }
    }
}

