/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gct;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class GctReader
implements ProjectReader {
    private List<String> suffixes = Collections.unmodifiableList(Arrays.asList("gct"));

    @Override
    public List<String> getFileSuffixes() {
        return this.suffixes;
    }

    @Override
    public String getFormatName() {
        return "gct";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project read(String file) throws IOException {
        try (BufferedReader br = null;){
            br = IOUtil.getBufferedReader(file);
            DefaultProject defaultProject = new DefaultProject(this.read(IOUtil.getName(file), br));
            return defaultProject;
        }
    }

    public Dataset read(String datasetName, InputStream is) throws IOException {
        return this.read(datasetName, new BufferedReader(new InputStreamReader(is)));
    }

    protected String getColumnString(int cols) {
        if (cols == 1) {
            return "column";
        }
        return "columns";
    }

    protected String getRowString(int rows) {
        if (rows == 1) {
            return "row";
        }
        return "rows";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Dataset read(String datasetName, BufferedReader br) throws IOException {
        int j;
        int expectedColumns;
        RowMajorArray2DDataset dataset;
        int ncols;
        int nrows;
        LineNumberReader reader = new LineNumberReader(br);
        String versionLine = reader.readLine();
        if (versionLine == null) {
            throw new IOException("Missing version line");
        }
        versionLine = versionLine.trim();
        String dimensionsLine = reader.readLine().trim();
        String columnNamesLine = reader.readLine().trim();
        int version = 2;
        if ("#1.2".equals(versionLine)) {
            version = 2;
        } else if ("#1.3".equals(versionLine)) {
            version = 3;
        }
        String[] dimensions = IOUtil.split(dimensionsLine);
        int numRowAnnotations = 1;
        int numColumnAnnotations = 0;
        try {
            nrows = Integer.parseInt(dimensions[0]);
            ncols = Integer.parseInt(dimensions[1]);
            dataset = new RowMajorArray2DDataset(datasetName, nrows, ncols);
            if (version == 3 && dimensions.length > 2) {
                numRowAnnotations = Integer.parseInt(dimensions[2]);
                numColumnAnnotations = Integer.parseInt(dimensions[3]);
            }
        }
        catch (NumberFormatException nfe) {
            if (version == 2) {
                throw new IOException("The second line should contain the number of rows and the number of columns separated by a tab.");
            }
            throw new IOException("The second line should contain the number of rows, the number of columns, the number of row annotations, and the number of column annotations separated by a tab.");
        }
        if (nrows <= 0 || ncols <= 0) {
            throw new IOException("Number of rows and columns must be greater than 0.");
        }
        String[] columnNamesArray = IOUtil.split(columnNamesLine);
        if (version == 2 && columnNamesArray.length != (expectedColumns = ncols + 2)) {
            throw new IOException("Expected " + (expectedColumns - 2) + " column names, but read " + (columnNamesArray.length - 2) + " column names on line " + reader.getLineNumber() + ".");
        }
        String name = columnNamesArray[0];
        int slashIndex = name.lastIndexOf(47);
        String columnIdFieldName = "id";
        String rowIdFieldName = "id";
        if (slashIndex != -1 && slashIndex < name.length() - 1) {
            rowIdFieldName = name.substring(0, slashIndex).trim();
            columnIdFieldName = name.substring(slashIndex + 1).trim();
        }
        Vector columnIds = MetadataUtil.addRowVector(dataset.getColumnMetadata(), columnIdFieldName, String.class);
        if (version != 3) {
            for (j = 0; j < ncols; ++j) {
                String columnName = columnNamesArray[j + numRowAnnotations + 1];
                columnIds.setValue(j, columnName);
            }
        } else {
            for (j = 0; j < ncols; ++j) {
                int index = j + numRowAnnotations + 1;
                String columnName = index < columnNamesArray.length ? columnNamesArray[index] : null;
                columnIds.setValue(j, columnName);
            }
        }
        MetadataUtil.addRowVector(dataset.getRowMetadata(), rowIdFieldName, String.class);
        if (version != 3) {
            MetadataUtil.addRowVector(dataset.getRowMetadata(), columnNamesArray[1], String.class);
        } else {
            for (j = 0; j < numRowAnnotations; ++j) {
                String rowMetadataName = "".equals(columnNamesArray[1]) ? "Description" : columnNamesArray[j + 1];
                rowMetadataName = MetadataUtil.createUniqueName(dataset.getRowMetadata(), rowMetadataName);
                MetadataUtil.addRowVector(dataset.getRowMetadata(), rowMetadataName, String.class);
            }
        }
        int dataColumnStart = numRowAnnotations + 1;
        int ntokens = ncols + numRowAnnotations + 1;
        String[] tokens = new String[ntokens];
        if (numColumnAnnotations > 0) {
            for (int columnAnnotationIndex = 0; columnAnnotationIndex < numColumnAnnotations; ++columnAnnotationIndex) {
                String line = reader.readLine();
                IOUtil.split(line, tokens, '\t');
                String metadataName = MetadataUtil.createUniqueName(dataset.getColumnMetadata(), tokens[0]);
                Vector v = MetadataUtil.addRowVector(dataset.getColumnMetadata(), metadataName, String.class);
                for (int j2 = 0; j2 < ncols; ++j2) {
                    v.setValue(j2, tokens[j2 + dataColumnStart]);
                }
            }
        }
        int rowIndex = 0;
        String s = reader.readLine();
        while (true) {
            block33: {
                block30: {
                    block31: {
                        block32: {
                            if (s == null) break block31;
                            if (rowIndex < nrows) break block32;
                            if (!s.trim().equals("")) {
                                int rowsRead = rowIndex + 1;
                                throw new IOException("More data rows than expected on line " + reader.getLineNumber() + ". Read " + rowsRead + ", expected " + nrows + ".");
                            }
                            --rowIndex;
                            break block33;
                        }
                        IOUtil.split(s, tokens, '\t');
                        if (version == 2) {
                            dataset.getRowMetadata().get(0).setValue(rowIndex, new String(tokens[0]));
                            dataset.getRowMetadata().get(1).setValue(rowIndex, new String(tokens[1]));
                            break block30;
                        } else {
                            int length = numRowAnnotations + 1;
                            for (int rowAnnotationIndex = 0; rowAnnotationIndex < length; ++rowAnnotationIndex) {
                                String rowMetadataValue = tokens[rowAnnotationIndex];
                                if (rowMetadataValue == null || rowMetadataValue.equals("")) continue;
                                dataset.getRowMetadata().setValue(rowIndex, rowAnnotationIndex, (Object)new String(rowMetadataValue));
                            }
                        }
                        break block30;
                    }
                    if (rowIndex != nrows) {
                        throw new IOException("Missing data rows. Read " + rowIndex + " " + this.getRowString(rowIndex) + ", expected " + nrows);
                    }
                    return dataset;
                }
                for (int columnIndex = 0; columnIndex < ncols; ++columnIndex) {
                    String token = tokens[columnIndex + dataColumnStart];
                    try {
                        dataset.setValue(rowIndex, columnIndex, ParserHelper.parseFloatNaN(token));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException(token + " at line number " + reader.getLineNumber() + " and column " + columnIndex + " is not a number.");
                    }
                }
            }
            s = reader.readLine();
            ++rowIndex;
        }
    }
}

