/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gct;

import java.io.IOException;
import java.io.PrintWriter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectWriter;
import org.broadinstitute.genee.io.matrix.gct.GctWriter13;
import org.broadinstitute.genee.io.util.DefaultStringConverter;
import org.broadinstitute.genee.io.util.StringConverter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;

public class GctWriter12
implements ProjectWriter {
    public static final String FORMAT_NAME = "gct#1.2";
    private StringConverter stringConverter = new DefaultStringConverter();

    @Override
    public String checkFileExtension(String filename) {
        if (!filename.toLowerCase().endsWith(".gct")) {
            filename = filename + ".gct";
        }
        return filename;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    public void setStringConverter(StringConverter stringConverter) {
        this.stringConverter = stringConverter;
    }

    @Override
    public void write(Project project, PrintWriter pw) throws IOException {
        Dataset dataset = project.getSortedFilteredDataset();
        int rows = dataset.getRowCount();
        int columns = dataset.getColumnCount();
        String version = "#1.2";
        pw.print(version);
        pw.print("\n");
        pw.print(rows + "\t" + columns);
        pw.print("\n");
        MetadataModel rowMetadata = GctWriter13.idFirst(dataset.getRowMetadata());
        MetadataModel columnMetadata = GctWriter13.idFirst(dataset.getColumnMetadata());
        String name = rowMetadata.getColumnName(0).equals(columnMetadata.getColumnName(0)) ? "Name" : rowMetadata.getColumnName(0) + "/" + columnMetadata.getColumnName(0);
        pw.print(name);
        pw.print("\t");
        pw.print("Description");
        Vector columnIds = columnMetadata.get(0);
        for (int j = 0; j < columns; ++j) {
            pw.print("\t");
            pw.print(this.stringConverter.toString(columnIds.getValue(j)));
        }
        Vector rowDescriptions = rowMetadata.get("Description");
        if (rowDescriptions == null && rowMetadata.getMetadataCount() > 1) {
            rowDescriptions = rowMetadata.get(1);
        }
        Vector rowIds = rowMetadata.get(0);
        for (int i = 0; i < rows; ++i) {
            Object rowDescription;
            pw.print("\n");
            pw.print(this.stringConverter.toString(rowIds.getValue(i)));
            pw.print("\t");
            Object object = rowDescription = rowDescriptions != null ? rowDescriptions.getValue(i) : null;
            if (rowDescription != null) {
                pw.print(this.stringConverter.toString(rowDescription));
            }
            for (int j = 0; j < columns; ++j) {
                pw.print("\t");
                pw.print(this.stringConverter.format(dataset.getValue(i, j)));
            }
        }
        pw.print("\n");
    }
}

