/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gctx;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.genee.io.matrix.gctx.GctxReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetColumnView;
import org.broadinstitute.genee.matrix.FloatList;

public class DatasetColumnChunkIterator
implements Iterator<FloatList> {
    private Dataset chunk;
    private int chunkSize;
    private int[] columnIndices;
    private DatasetColumnView columnView;
    private int currentColumnIndex;
    private int maxLoadedColumnIndexPlusOne;
    private int ncols;
    private int offsetInChunk;
    private GctxReader reader;
    private int[] rowIndices;
    private boolean rowIndicesAreAscending;
    private boolean columnIndicesAreAscending;

    public DatasetColumnChunkIterator(GctxReader reader, int[] rowIndices, int[] columnIndices, boolean rowIndicesAreAscending, boolean columnIndicesAreAscending) {
        this.reader = reader;
        this.rowIndices = rowIndices;
        GctxReader.DatasetInfo info = reader.getDatasetInfo();
        if (columnIndices == null) {
            columnIndices = IOUtil.seqInt(info.ncols);
        }
        this.columnIndices = columnIndices;
        this.ncols = columnIndices.length;
        this.chunkSize = 100;
        this.rowIndicesAreAscending = rowIndicesAreAscending;
        this.columnIndicesAreAscending = columnIndicesAreAscending;
    }

    public void close() {
        this.reader.close();
    }

    public float getFullColumnCount() {
        return this.columnIndices.length;
    }

    @Override
    public boolean hasNext() {
        return this.currentColumnIndex < this.ncols;
    }

    @Override
    public FloatList next() {
        if (this.currentColumnIndex < this.ncols) {
            if (this.currentColumnIndex == this.maxLoadedColumnIndexPlusOne) {
                try {
                    this.loadNextChunk();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.columnView.setIndex(this.offsetInChunk);
            ++this.offsetInChunk;
            ++this.currentColumnIndex;
            return this.columnView;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void loadNextChunk() throws Exception {
        int minIndex = this.maxLoadedColumnIndexPlusOne;
        this.maxLoadedColumnIndexPlusOne = Math.min(this.ncols, minIndex + this.chunkSize);
        int[] tmp = new int[this.maxLoadedColumnIndexPlusOne - minIndex];
        int i = 0;
        int j = minIndex;
        int length = tmp.length;
        while (i < length) {
            tmp[i] = this.columnIndices[j];
            ++i;
            ++j;
        }
        this.chunk = this.reader.read(this.rowIndices, tmp, false, false, this.rowIndicesAreAscending, this.columnIndicesAreAscending);
        this.columnView = new DatasetColumnView(this.chunk);
        this.offsetInChunk = 0;
    }
}

