/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gctx;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.matrix.gctx.GctxReader;
import org.broadinstitute.genee.io.util.IOUtil;

public class GctxProjectReader
implements ProjectReader {
    private static final List<String> SUFFIXES = Arrays.asList("h5", "gctx");

    @Override
    public List<String> getFileSuffixes() {
        return SUFFIXES;
    }

    @Override
    public String getFormatName() {
        return "gctx";
    }

    @Override
    public Project read(String path) throws IOException {
        return this.read(path, null, null, true, true);
    }

    public Project read(String path, int[] rowIndices, int[] columnIndices, boolean rowIndicesAreSorted, boolean columnIndicesAreSorted) throws IOException {
        File tmpFile = null;
        if (!new File(path).exists()) {
            try {
                tmpFile = File.createTempFile(IOUtil.getBaseFileName(path), ".gctx");
            }
            catch (IOException x) {
                tmpFile = File.createTempFile("download", ".gctx");
            }
            IOUtil.download(path, tmpFile);
            path = tmpFile.getCanonicalPath();
        }
        try {
            Project x = GctxReader.readProject(path, rowIndices, columnIndices, rowIndicesAreSorted, columnIndicesAreSorted);
            return x;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }
}

