/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gctx;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import ncsa.hdf.hdf5lib.HDF5Constants;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectWriter;
import org.broadinstitute.genee.io.matrix.gctx.GctxWriter;
import org.broadinstitute.genee.io.persistence.GENEEOptions;
import org.broadinstitute.genee.matrix.Dataset;

public class GctxProjectWriter
implements ProjectWriter {
    public static final String COL_METADATA_PATH = "/0/META/COL";
    public static final String DATA_MATRIX_PATH = "/0/DATA/0/matrix";
    public static final String FORMAT_NAME = "gctx";
    public static final String ROW_METADATA_PATH = "/0/META/ROW";
    private static List<String> EXTENSIONS = Arrays.asList(".h5", ".gctx");
    private long columnDataChunkSize = 4L;
    private boolean gzip = true;
    private int matrixDataType = HDF5Constants.H5T_IEEE_F32BE;
    private long rowDataChunkSize = -1L;
    private boolean writeInSlabs = true;

    @Override
    public String checkFileExtension(String pathname) {
        String name = pathname.toLowerCase();
        boolean found = false;
        for (String ext : EXTENSIONS) {
            if (!name.endsWith(ext)) continue;
            found = true;
            break;
        }
        if (!found) {
            pathname = pathname + ".gctx";
        }
        return pathname;
    }

    public long getColumnDataChunkSize() {
        return this.columnDataChunkSize;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    public long getRowDataChunkSize() {
        return this.rowDataChunkSize;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public boolean isWriteInSlabs() {
        return this.writeInSlabs;
    }

    public void setColumnDataChunkSize(long columnDataChunkSize) {
        this.columnDataChunkSize = columnDataChunkSize;
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    public void setMatrixDataType(int matrixDataType) {
        this.matrixDataType = matrixDataType;
    }

    public void setRowDataChunkSize(long rowDataChunkSize) {
        this.rowDataChunkSize = rowDataChunkSize;
    }

    public void setWriteInSlabs(boolean writeInSlabs) {
        this.writeInSlabs = writeInSlabs;
    }

    @Override
    public void write(Project project, PrintWriter pw) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(Project project, String path) throws IOException {
        try (GctxWriter writer = null;){
            ByteArrayOutputStream os;
            new File(path).delete();
            writer = new GctxWriter(path);
            writer.setGzip(this.gzip);
            writer.setWriteInSlabs(this.writeInSlabs);
            writer.setColumnDataChunkSize(this.columnDataChunkSize);
            writer.setMatrixDataType(this.matrixDataType);
            writer.setRowDataChunkSize(this.rowDataChunkSize);
            Dataset d = project.getSortedFilteredDataset();
            writer.writeDataset(DATA_MATRIX_PATH, d);
            ProjectGENEEResultTreeNode node = (ProjectGENEEResultTreeNode)d.getProperty("project.node");
            if (node != null) {
                writer.writeBytes("/0/DATA/GENE_E", GENEEOptions.toString(node).getBytes(Charset.forName("UTF-8")));
            }
            if (project.getRowDendrogram() != null && project.isRowSortOrderPreservesDendrogram()) {
                os = new ByteArrayOutputStream();
                project.getRowDendrogram().save(os, "gtr");
                writer.writeBytes("/0/DATA/row_dendrogram", os.toByteArray());
            }
            if (project.getColumnDendrogram() != null && project.isColumnSortOrderPreservesDendrogram()) {
                os = new ByteArrayOutputStream();
                project.getColumnDendrogram().save(os, "atr");
                writer.writeBytes("/0/DATA/column_dendrogram", os.toByteArray());
            }
        }
    }
}

