/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.plate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.io.matrix.plate.PlateFileInfo;
import org.broadinstitute.genee.io.matrix.plate.SpectraMaxFileInfo;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class SpectraMaxReader {
    public List<Dataset> read(String file) throws IOException {
        SpectraMaxFileInfo fileInfo = new SpectraMaxFileInfo(file);
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        int nplates = fileInfo.getNumberOfPlates();
        for (int i = 0; i < nplates; ++i) {
            list.add(this.read(fileInfo, i));
        }
        return list;
    }

    public Dataset read(PlateFileInfo fileInfo, int plateIndex) throws IOException {
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(fileInfo.getPlateName(plateIndex), fileInfo.getRows(), fileInfo.getColumns());
        SpectraMaxFileInfo spectraMaxFileInfo = (SpectraMaxFileInfo)fileInfo;
        float[][] matrix = spectraMaxFileInfo.getMatrix(plateIndex);
        int rows = spectraMaxFileInfo.getRows();
        for (int i = 0; i < rows; ++i) {
            int cols = spectraMaxFileInfo.getColumns();
            for (int j = 0; j < cols; ++j) {
                dataset.setValue(i, j, matrix[i][j]);
            }
        }
        return dataset;
    }
}

