/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.res;

import java.io.IOException;
import java.io.PrintWriter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectWriter;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Vector;

public class ResWriter
implements ProjectWriter {
    static final String FORMAT_NAME = "res";

    @Override
    public String checkFileExtension(String filename) {
        if (!filename.toLowerCase().endsWith(".res")) {
            filename = filename + ".res";
        }
        return filename;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    @Override
    public void write(Project project, PrintWriter pw) throws IOException {
        Dataset dataset = project.getSortedFilteredDataset();
        this.writeHeader(dataset, pw);
        int rows = dataset.getRowCount();
        int columns = dataset.getColumnCount();
        int callsSeriesIndex = DatasetUtil.getSeriesIndex(dataset, "A-P calls");
        Vector rowDescriptions = dataset.getRowMetadata().get("Description");
        if (rowDescriptions == null && dataset.getRowMetadata().getMetadataCount() > 1) {
            rowDescriptions = dataset.getRowMetadata().get(1);
        }
        Vector rowIds = dataset.getRowMetadata().get(0);
        for (int i = 0; i < rows; ++i) {
            Object rowDescription;
            pw.print("\n");
            Object object = rowDescription = rowDescriptions != null ? rowDescriptions.getValue(i) : null;
            if (rowDescription != null) {
                pw.print(Formatter.toString(rowDescription));
            }
            pw.print("\t");
            pw.print(Formatter.toString(rowIds.getValue(i)));
            for (int j = 0; j < columns; ++j) {
                pw.print("\t");
                pw.print(Formatter.format(dataset.getValue(i, j)));
                pw.print("\t");
                pw.print(callsSeriesIndex != -1 ? dataset.getObjectValue(i, j, callsSeriesIndex) : "");
            }
        }
    }

    public void writeHeader(Dataset data, PrintWriter pw) throws IOException {
        String columnDescription;
        int rows = data.getRowCount();
        int columns = data.getColumnCount();
        pw.print("Description");
        pw.print("\t");
        pw.print("Accession");
        pw.print("\t");
        Vector columnIds = data.getColumnMetadata().get(0);
        pw.print(columnIds.getValue(0));
        for (int j = 1; j < columns; ++j) {
            pw.print("\t\t");
            pw.print(columnIds.getValue(j));
        }
        pw.print("\n");
        pw.print("\t");
        boolean containsColumnDescription = data.getColumnMetadata().getColumnIndex("Description") != -1;
        String string = columnDescription = containsColumnDescription ? (String)data.getColumnMetadata().getValue(0, "Description") : "";
        if (columnDescription == null) {
            columnDescription = "";
        }
        pw.print(columnDescription);
        for (int j = 1; j < columns; ++j) {
            pw.print("\t\t");
            String string2 = columnDescription = containsColumnDescription ? (String)data.getColumnMetadata().getValue(j, "Description") : "";
            if (columnDescription == null) {
                columnDescription = "";
            }
            pw.print(columnDescription);
        }
        pw.print("\n");
        pw.print(rows);
        pw.flush();
    }
}

