/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.persistence;

import java.awt.Color;
import org.broadinstitute.genee.heatmap.HeatMapPanel;

public class HeatMapDisplayPersistence {
    private float rowSize;
    private float columnSize;
    private boolean showGrid;
    private boolean synchronizeSizes;
    private Color gridColor;
    private int columnCategoriesHeight;
    private int rowCategoriesWidth;
    private boolean showColumnCategoriesGrid;
    private boolean showRowCategoriesGrid;
    private boolean showValues;
    private float rowDendrogramLineThickness;
    private float columnDendrogramLineThickness;
    private float gapSize;

    public HeatMapDisplayPersistence() {
    }

    public HeatMapDisplayPersistence(HeatMapPanel p) {
        this.rowSize = p.getRowSize();
        this.columnSize = p.getColumnSize();
        this.showGrid = p.isDrawGrid();
        this.synchronizeSizes = p.isSquareAspect();
        this.gridColor = p.getGridColor();
        this.columnCategoriesHeight = p.getColumnCategoryPanel().getSizePerClass();
        this.rowCategoriesWidth = p.getRowCategoryPanel().getSizePerClass();
        this.showColumnCategoriesGrid = p.getColumnCategoryPanel().isGridVisible();
        this.showRowCategoriesGrid = p.getRowCategoryPanel().isGridVisible();
        this.showValues = p.isDrawValues();
        this.gapSize = p.getRowSizesAndPositions().getSpaceSize();
        if (p.getRowDendrogramPanel() != null) {
            this.rowDendrogramLineThickness = p.getRowDendrogramPanel().getDendrogramLineThickness();
        }
        if (p.getColumnDendrogramPanel() != null) {
            this.columnDendrogramLineThickness = p.getColumnDendrogramPanel().getDendrogramLineThickness();
        }
    }

    public static void configure(HeatMapPanel p, HeatMapDisplayPersistence persistence) {
        if (persistence != null) {
            p.setRowSize(persistence.rowSize);
            p.setColumnSize(persistence.columnSize);
            p.setDrawGrid(persistence.showGrid);
            p.setSquareAspect(persistence.synchronizeSizes);
            p.setGridColor(persistence.gridColor);
            if (persistence.gapSize > 0.0f) {
                p.setSpaceSize(persistence.gapSize);
            }
            p.getColumnCategoryPanel().setSizePerClass(persistence.columnCategoriesHeight);
            p.getRowCategoryPanel().setSizePerClass(persistence.rowCategoriesWidth);
            p.getColumnCategoryPanel().setGridVisible(persistence.showColumnCategoriesGrid);
            p.getRowCategoryPanel().setGridVisible(persistence.showRowCategoriesGrid);
            p.setDrawValues(persistence.showValues);
            if (p.getRowDendrogramPanel() != null && persistence.rowDendrogramLineThickness > 0.0f) {
                p.getRowDendrogramPanel().setDendrogramLineThickness(persistence.rowDendrogramLineThickness);
            }
            if (p.getColumnDendrogramPanel() != null && persistence.columnDendrogramLineThickness > 0.0f) {
                p.getColumnDendrogramPanel().setDendrogramLineThickness(persistence.columnDendrogramLineThickness);
            }
        }
    }
}

