/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.broadinstitute.genee.io.util.DelimWriter;
import org.broadinstitute.genee.io.util.Formatter;

public class ExcelWriter
implements DelimWriter {
    private XSSFWorkbook wb = new XSSFWorkbook();
    private XSSFSheet sheet = this.wb.createSheet();
    private int row = 0;
    private XSSFCell c;
    private XSSFRow r;
    private int column;
    private File file;

    public ExcelWriter() {
        this.nextRow();
    }

    @Override
    public void close() throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.file));
        this.wb.write((OutputStream)os);
        ((OutputStream)os).close();
    }

    @Override
    public void init(File file) {
        if (!file.getName().endsWith(".xlsx")) {
            file = new File(file.getParentFile(), file.getName() + ".xlsx");
        }
        this.file = file;
    }

    @Override
    public void nextColumn() {
        this.c = this.r.createCell(this.column);
        ++this.column;
    }

    @Override
    public void nextRow() {
        this.r = this.sheet.createRow(this.row);
        this.column = 0;
        this.nextColumn();
    }

    @Override
    public void print(String text) {
        this.c.setCellValue(text);
    }

    @Override
    public void print(int value) {
        this.c.setCellValue((double)value);
    }

    @Override
    public void print(Object value) {
        this.c.setCellValue(Formatter.toString(value));
    }
}

