/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public class ExtendedProperties
extends Properties {
    private static final long serialVersionUID = 8904709563073950956L;

    public ExtendedProperties() {
    }

    public ExtendedProperties(Properties defs) {
        super(defs);
    }

    @Override
    public String getProperty(String key) {
        String result = super.getProperty(key);
        return result == null ? null : this.expandValue(result);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String result = this.getProperty(key);
        return result == null ? this.expandValue(defaultValue) : result;
    }

    public ExtendedProperties getSubset(String prefix) {
        return this.getSubset(prefix, "");
    }

    public ExtendedProperties getSubset(String prefix, String newPrefix) {
        ExtendedProperties result = new ExtendedProperties();
        Iterator<Object> it = this.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.startsWith(prefix) || key.equals(prefix)) continue;
            result.put(key.substring(prefix.length()) + newPrefix, this.getProperty(key));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File f) throws IOException {
        try (BufferedInputStream is = null;){
            is = new BufferedInputStream(new FileInputStream(f));
            this.load(is);
        }
    }

    private String expandValue(String value) {
        if (value == null || value.length() < 4) {
            return value;
        }
        StringBuilder result = new StringBuilder(value.length());
        result.append(value);
        int p1 = result.indexOf("${");
        int p2 = result.indexOf("}", p1 + 2);
        while (p1 >= 0 && p2 > p1) {
            String paramName = result.substring(p1 + 2, p2);
            String paramValue = this.getProperty(paramName);
            if (paramValue != null) {
                result.replace(p1, p2 + 1, paramValue);
                p1 += paramValue.length();
            } else {
                p1 = p2 + 1;
            }
            p1 = result.indexOf("${", p1);
            p2 = result.indexOf("}", p1 + 2);
        }
        return result.toString();
    }
}

