/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import chemaxon.struc.Molecule;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.io.util.ToStringUtil;

public class Formatter {
    static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    static String NaN = "NaN";
    static final NumberFormat SHORT_NF = NumberFormat.getInstance();
    static com.ibm.icu.text.DecimalFormat SIG_DIGIT_FORMAT = new com.ibm.icu.text.DecimalFormat("@@##");

    public static synchronized String format(Date value) {
        return DATE_FORMAT.format(value);
    }

    public static synchronized String format(double value) {
        if (Double.isNaN(value)) {
            return NaN;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (value == 0.0) {
            return "0";
        }
        if (value > -1.0 && value < 1.0) {
            return SIG_DIGIT_FORMAT.format(value);
        }
        return SHORT_NF.format(value);
    }

    public static synchronized String format(float value) {
        if (Float.isNaN(value)) {
            return NaN;
        }
        if (value == Float.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (value == 0.0f) {
            return "0";
        }
        if (value > -1.0f && value < 1.0f) {
            return SIG_DIGIT_FORMAT.format((double)value);
        }
        return SHORT_NF.format(value);
    }

    public static synchronized String format(Number number) {
        if (number instanceof Double || number instanceof Float) {
            double value = number.doubleValue();
            return Formatter.format(value);
        }
        return SHORT_NF.format(number);
    }

    public static String getNaN() {
        return NaN;
    }

    public static void setNaN(String text) {
        NaN = text;
    }

    public static String toString(Object value) {
        if (value instanceof Number) {
            return Formatter.format((Number)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Molecule) {
            Molecule m = (Molecule)value;
            return m == null ? "" : MoleculeUtil.toSmile(m);
        }
        if (value instanceof Collection) {
            return ToStringUtil.toString((Collection)value, ", ");
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    static {
        com.ibm.icu.text.DecimalFormatSymbols sigDigitSymbols = SIG_DIGIT_FORMAT.getDecimalFormatSymbols();
        sigDigitSymbols.setDecimalSeparator('.');
        SIG_DIGIT_FORMAT.setDecimalFormatSymbols(sigDigitSymbols);
        SIG_DIGIT_FORMAT.setGroupingUsed(false);
        if (SHORT_NF instanceof DecimalFormat) {
            DecimalFormatSymbols symbols = ((DecimalFormat)SHORT_NF).getDecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
        }
        SHORT_NF.setMaximumIntegerDigits(Integer.MAX_VALUE);
        SHORT_NF.setMaximumFractionDigits(2);
        SHORT_NF.setGroupingUsed(false);
    }
}

