/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipInputStream;
import org.broadinstitute.genee.gui.NullProgressNotifier;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.io.matrix.cls.ClsReader;
import org.broadinstitute.genee.io.matrix.cls.ClsWriter;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.StreamCopier;
import org.broadinstitute.genee.matrix.ClassVector;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DefaultClassVector;

public class IOUtil {
    public static final int DEFAULT_CHAR_BUFFER_SIZE = 0x100000;
    public static final char[] PROHIBITED_WINDOWS_FILE_NAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    public static final String PROHIBITED_WINDOWS_FILE_NAME_PATTERN;
    private static ClsReader clsReader;
    private static final Pattern COMMA_PATTERN;
    private static final Pattern TAB_PATTERN;
    public static final String BASH = "#!/bin/bash";

    private IOUtil() {
    }

    public static List<String> createJavaCommandLine(String memory) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("java");
        list.add("-Djava.library.path=" + System.getProperty("java.library.path"));
        list.add("-Djava.awt.headless=true");
        list.add("-Xmx" + memory);
        list.add("-cp");
        list.add(System.getProperty("java.class.path"));
        return list;
    }

    public static void deleteRecursively(File inputDir) {
        if (!inputDir.isDirectory()) {
            inputDir.delete();
        } else {
            try {
                Files.walkFileTree(inputDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                        if (e == null) {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        throw e;
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String stripQuotes(String s) {
        int nchars = s.length();
        if (nchars <= 2) {
            return s;
        }
        char c = s.charAt(0);
        if (c == '\"' && s.charAt(nchars - 1) == '\"') {
            return s.substring(1, nchars - 1);
        }
        return s;
    }

    public static void runCommand(String ... args) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        StreamCopier copy = new StreamCopier(p.getInputStream(), System.out);
        copy.start();
        p.waitFor();
        copy.join();
    }

    public static <T> Map<T, Integer> buildIndexMap(Collection<T> values) {
        LinkedHashMap<T, Integer> map = new LinkedHashMap<T, Integer>();
        int i = 0;
        for (T val : values) {
            map.put(val, i++);
        }
        return map;
    }

    public static void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUrl(URL url) {
        InputStream is = null;
        try {
            int n;
            is = url.openStream();
            StringBuilder sb = new StringBuilder();
            byte[] b = new byte[1024];
            while ((n = is.read(b)) != -1) {
                sb.append(new String(b, 0, n));
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[102400];
        try {
            int bytesRead;
            while ((bytesRead = is.read(buf)) != -1) {
                os.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        byte[] buf = new byte[102400];
        InputStream is = null;
        OutputStream os = null;
        if (!dest.exists()) {
            dest.createNewFile();
        }
        try {
            int bytesRead;
            is = new BufferedInputStream(new FileInputStream(source));
            os = new BufferedOutputStream(new FileOutputStream(dest));
            while ((bytesRead = is.read(buf)) != -1) {
                os.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void copyFile(InputStream is, File dest) throws IOException {
        if (!dest.exists()) {
            dest.getParentFile().mkdirs();
            dest.createNewFile();
        }
        IOUtil.copy(is, new BufferedOutputStream(new FileOutputStream(dest)));
    }

    public static void createPath(String path) {
        File file = new File(path);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public static boolean download(String url, File dest) {
        return IOUtil.download(url, dest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean download(String url, File dest, boolean gzip) {
        InputStream is = null;
        OutputStream os = null;
        try {
            int bytesRead;
            URLConnection conn = new URL(url).openConnection();
            is = conn.getInputStream();
            os = gzip ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(dest))) : new BufferedOutputStream(new FileOutputStream(dest));
            byte[] array = new byte[10240];
            while ((bytesRead = is.read(array)) > 0) {
                os.write(array, 0, bytesRead);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            dest.delete();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void exit(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public static String fixPath(String path) {
        if (path == null) {
            return path;
        }
        File file = new File(path);
        if (!file.exists()) {
            if (path.startsWith("/cmap") && !new File("/cmap").exists()) {
                path = path.replace("/cmap/", "\\\\neon\\cmap\\").replace("/", "\\");
            } else if (path.startsWith("/xchip/obelix") && !new File("/xchip/obelix").exists()) {
                path = path.replace("/xchip/obelix/", "\\\\argon\\xchip_obelix\\").replace("/", "\\");
            }
        }
        return path;
    }

    public static String toUnixPath(File path) {
        return IOUtil.toUnixPath(IOUtil.getPath(path));
    }

    public static String toUnixPath(String path) {
        if (path == null) {
            return path;
        }
        path = path.replace("Z:\\jgould\\", "/xchip/cogs/jgould/");
        path = path.replace("\\\\nitrogen\\xchip_cogs\\", "/xchip/cogs/");
        path = path.replace("\\\\argon\\xchip_obelix\\", "/xchip/obelix/");
        path = path.replace("\\", "/");
        return path;
    }

    public static String getBaseFileName(File filepath) {
        return IOUtil.getBaseFileName(filepath.getName());
    }

    public static String getBaseFileName(String filepath) {
        String name = IOUtil.getName(filepath);
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex > 0) {
            String suffix = name.substring(dotIndex + 1, name.length());
            if (suffix.equalsIgnoreCase("gz") || suffix.equalsIgnoreCase("zip") || suffix.equalsIgnoreCase("bz2")) {
                return IOUtil.getBaseFileName(name.substring(0, dotIndex));
            }
            return name.substring(0, dotIndex);
        }
        return name;
    }

    public static BufferedReader getBufferedReader(File file) throws IOException {
        return IOUtil.getBufferedReader(file.getCanonicalPath());
    }

    public static BufferedReader getBufferedReader(String file) throws IOException {
        return new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file), "UTF-8"), 0x100000);
    }

    public static String getExtension(File file) {
        return IOUtil.getExtension(file.getName());
    }

    public static String getExtension(String name) {
        name = new File(name).getName();
        int dotIndex = name.lastIndexOf(".");
        String suffix = null;
        if (dotIndex > 0) {
            suffix = name.substring(dotIndex + 1, name.length());
        }
        if (suffix == null) {
            return null;
        }
        if (suffix.equals("txt") && name.endsWith("_matrix.txt")) {
            return "_matrix.txt";
        }
        if (suffix.equals("txt") || suffix.equals("xls")) {
            String secondSuffix;
            String newPath = name.substring(0, dotIndex);
            int secondDotIndex = newPath.lastIndexOf(46);
            if (secondDotIndex != -1 && ((secondSuffix = newPath.substring(secondDotIndex + 1, newPath.length())).equalsIgnoreCase("res") || secondSuffix.equalsIgnoreCase("gct") || secondSuffix.equalsIgnoreCase("cn") || secondSuffix.equalsIgnoreCase("sin") || secondSuffix.equalsIgnoreCase("cls") || secondSuffix.equalsIgnoreCase("gin"))) {
                return secondSuffix.toLowerCase();
            }
        } else if (suffix.equals("zip") || suffix.equals("gz") || suffix.equals("bz2")) {
            String newPath = name.substring(0, dotIndex);
            return IOUtil.getExtension(newPath);
        }
        return suffix.toLowerCase();
    }

    public static InputStream getInputStream(String pathname) throws IOException {
        InputStream is;
        if (pathname == null) {
            throw new NullPointerException("pathname is null.");
        }
        try {
            URL url = new URL(pathname);
            URLConnection conn = url.openConnection();
            is = conn.getInputStream();
        }
        catch (MalformedURLException e1) {
            is = new FileInputStream(pathname);
        }
        if (pathname.toLowerCase().endsWith(".zip")) {
            ZipInputStream zis = new ZipInputStream(is);
            zis.getNextEntry();
            return zis;
        }
        if (pathname.toLowerCase().endsWith(".gz")) {
            return new GZIPInputStream(is);
        }
        if (pathname.toLowerCase().endsWith(".bz2")) {
            try {
                Class<?> c = Class.forName("org.apache.tools.bzip2.CBZip2InputStream");
                return (InputStream)c.getConstructor(InputStream.class).newInstance(is);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return is;
    }

    public static LineNumberReader getLineNumberReader(String file) throws IOException {
        return new LineNumberReader(new InputStreamReader(IOUtil.getInputStream(file)), 0x100000);
    }

    public static String getName(String pathname) {
        try {
            String file;
            int slashIndex;
            URL url = new URL(pathname);
            int urlFileNameIndex = pathname.indexOf("filename=");
            if (urlFileNameIndex != -1) {
                int endIndex = pathname.indexOf(38, urlFileNameIndex + "filename=".length());
                return pathname.substring(urlFileNameIndex + "filename=".length(), endIndex == -1 ? pathname.length() : endIndex);
            }
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                String name;
                int filenameIndex;
                ((HttpURLConnection)conn).setRequestMethod("HEAD");
                String contentDisposition = conn.getHeaderField("Content-Disposition");
                if (contentDisposition != null && (filenameIndex = contentDisposition.indexOf("filename=")) >= 0 && !(name = contentDisposition.substring(filenameIndex + "filename=".length()).trim()).equals("")) {
                    return name;
                }
            }
            if ((slashIndex = (file = url.toString()).lastIndexOf("/")) != -1 && slashIndex != file.length() - 1) {
                return file.substring(slashIndex + 1);
            }
            return "";
        }
        catch (Exception x) {
            return new File(pathname).getName();
        }
    }

    public static String getOutputFileNameDimensions(Dataset d) {
        StringBuilder sb = new StringBuilder();
        sb.append("_n");
        sb.append(d.getColumnCount());
        sb.append("x");
        sb.append(d.getRowCount());
        return sb.toString();
    }

    public static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getPath();
        }
    }

    public static String getStackTrace(int maxDepth) {
        RuntimeException t = new RuntimeException();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < Math.min(maxDepth, trace.length); ++i) {
            pw.println("\tat " + trace[i]);
        }
        pw.close();
        return sw.toString();
    }

    public static File getTmpFsDir() {
        File dir = new File("/tmp/shm");
        return dir.exists() ? dir : new File(System.getProperty("java.io.tmpdir"));
    }

    public static File getUniqueFile(String directory, String name, String extension) {
        File f = new File(directory, name + extension);
        int counter = 1;
        while (f.exists()) {
            f = new File(directory, name + "-" + counter + extension);
            ++counter;
        }
        return f;
    }

    public static boolean isAssignableFrom(Class[] array, Class cls) {
        for (Class c : array) {
            if (!c.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumber(Class<?> c) {
        return Number.class.isAssignableFrom(c) || Float.TYPE.isAssignableFrom(c) || Integer.TYPE.isAssignableFrom(c);
    }

    public static boolean isUrl(String file) {
        try {
            new URL(file);
            return true;
        }
        catch (MalformedURLException e1) {
            return false;
        }
    }

    public static File[] listDirs(File rootDir, FileFilter dirFilter, boolean recursive) throws InterruptedException {
        if (dirFilter == null) {
            dirFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return true;
                }
            };
        }
        HashSet<File> set = new HashSet<File>();
        IOUtil._listDirs(rootDir, set, dirFilter, recursive);
        return set.toArray(new File[0]);
    }

    public static File[] listFiles(File rootDir, FileFilter fileFilter, FileFilter dirFilter, ProgressNotifier progressNotifier, boolean recursive) throws InterruptedException {
        HashSet<File> set = new HashSet<File>();
        if (fileFilter == null) {
            fileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return true;
                }
            };
        }
        if (dirFilter == null) {
            dirFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return true;
                }
            };
        }
        if (progressNotifier == null) {
            progressNotifier = new NullProgressNotifier();
        }
        IOUtil.listFiles(rootDir, fileFilter, dirFilter, set, progressNotifier, recursive);
        return set.toArray(new File[0]);
    }

    public static List<String> loadList(Preferences p, String baseName) {
        ArrayList<String> list = new ArrayList<String>();
        int size = p.getInt(baseName, 0);
        for (int i = 0; i < size; ++i) {
            String value = p.get(baseName + i, null);
            list.add(value);
        }
        return list;
    }

    public static void makeUnique(String[] names, String s) {
        HashSet<String> nameSet = new HashSet<String>(names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (nameSet.contains(name)) {
                int j = 1;
                String newName = name + "-" + j;
                while (nameSet.contains(newName)) {
                    newName = name + "-" + j;
                    ++j;
                }
                names[i] = name = newName;
            }
            nameSet.add(name);
        }
    }

    public static String[] parseCsv(String s) {
        if (s != null) {
            String[] tokens = s.split(",");
            int length = tokens.length;
            for (int i = 0; i < length; ++i) {
                tokens[i] = tokens[i].trim();
            }
            return tokens;
        }
        return new String[0];
    }

    public static int[] rangeToIntArray(String rangeString) {
        TIntArrayList indices = new TIntArrayList();
        String[] tokens = rangeString.split(",");
        int length = tokens.length;
        for (int j = 0; j < length; ++j) {
            String s = tokens[j].trim();
            if (s.equals("")) continue;
            int dashIndex = -1;
            dashIndex = s.indexOf("-");
            if (dashIndex != -1) {
                int i;
                int first = 0;
                try {
                    first = Integer.parseInt(s.substring(0, dashIndex).trim());
                }
                catch (NumberFormatException nfe) {
                    throw new NumberFormatException(s.substring(0, dashIndex).trim() + " is not a number.");
                }
                int last = 0;
                try {
                    last = Integer.parseInt(s.substring(dashIndex + 1, s.length()).trim());
                }
                catch (NumberFormatException nfe) {
                    throw new NumberFormatException(s.substring(dashIndex + 1, s.length()).trim() + " is not a number.");
                }
                if (first <= last) {
                    for (i = first; i <= last; ++i) {
                        indices.add(i);
                    }
                    continue;
                }
                for (i = first; i >= last; --i) {
                    indices.add(i);
                }
                continue;
            }
            try {
                int index = Integer.parseInt(s.trim());
                indices.add(index);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException(s.trim() + " is not a number.");
            }
        }
        return indices.toArray();
    }

    public static DefaultClassVector readCls(String pathname) throws IOException {
        return clsReader.read(pathname);
    }

    public static void reverse(int[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void saveList(List<String> list, Preferences p, String baseName) {
        p.putInt(baseName, list.size());
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            p.put(baseName + i, list.get(i));
        }
    }

    public static int[] semicolonRangeToIntArray(String rangeString) {
        TIntArrayList indices = new TIntArrayList();
        String[] tokens = rangeString.split(",");
        int length = tokens.length;
        for (int j = 0; j < length; ++j) {
            String s = tokens[j].trim();
            String[] range = s.split(":");
            if (range.length == 1) {
                int index = ParserHelper.parseInt(s.trim());
                indices.add(index);
                continue;
            }
            if (range.length == 2 || range.length == 3) {
                IOUtil.addToArray(range, indices);
                continue;
            }
            throw new NumberFormatException(s + " does not specify a valid range.");
        }
        return indices.toArray();
    }

    public static int[] seqInt(int length) {
        return IOUtil.seqInt(0, length, 1);
    }

    public static int[] seqInt(int startValue, int length, int incremenent) {
        int[] a = new int[length];
        int i = 0;
        int d = startValue;
        while (i < length) {
            a[i] = d;
            ++i;
            d += incremenent;
        }
        return a;
    }

    public static String[] split(String s) {
        return TAB_PATTERN.split(s, 0);
    }

    public static String[] split(String s, int limit) {
        return TAB_PATTERN.split(s, limit);
    }

    public static int split(String s, String[] tokens, char delim) {
        int end;
        int tokenIndex;
        int start = 0;
        int ntokens = tokens.length;
        for (tokenIndex = 0; (end = s.indexOf(delim, start)) != -1 && tokenIndex < ntokens; ++tokenIndex) {
            tokens[tokenIndex] = s.substring(start, end);
            start = end + 1;
        }
        if (tokenIndex < ntokens) {
            tokens[tokenIndex++] = s.substring(start);
        }
        int numRead = tokenIndex;
        while (tokenIndex < ntokens) {
            tokens[tokenIndex] = "";
            ++tokenIndex;
        }
        return numRead;
    }

    public static String[] splitComma(String s) {
        return COMMA_PATTERN.split(s, 0);
    }

    public static float[] subset(float[] array, int[] indices) {
        float[] tmp = new float[indices.length];
        int size = indices.length;
        for (int i = 0; i < size; ++i) {
            tmp[i] = array[indices[i]];
        }
        return tmp;
    }

    public static int[] subset(int[] array, int[] indices) {
        int[] tmp = new int[indices.length];
        int size = indices.length;
        for (int i = 0; i < size; ++i) {
            tmp[i] = array[indices[i]];
        }
        return tmp;
    }

    public static List<Object>[][] subset(List<Object>[][] existingArray, TIntArrayList rowIndices, TIntArrayList columnIndices) {
        List[][] tmp = new List[rowIndices.size()][columnIndices.size()];
        for (int i = 0; i < rowIndices.size(); ++i) {
            for (int j = 0; j < columnIndices.size(); ++j) {
                tmp[i][j] = existingArray[rowIndices.getQuick(i)][columnIndices.getQuick(j)];
            }
        }
        return tmp;
    }

    public static <T> List<T>[] subset(List<T>[] existingArray, TIntArrayList indices) {
        List[] tmp = new List[indices.size()];
        int size = indices.size();
        for (int i = 0; i < size; ++i) {
            tmp[i] = existingArray[indices.getQuick(i)];
        }
        return tmp;
    }

    public static float[] toFloat(double[] doubleArray) {
        float[] floatArray = new float[doubleArray.length];
        int rows = floatArray.length;
        for (int i = 0; i < rows; ++i) {
            floatArray[i] = (float)doubleArray[i];
        }
        return floatArray;
    }

    public static float[][] toFloat(double[][] matrix) {
        float[][] array = new float[matrix.length][matrix[0].length];
        int rows = array.length;
        for (int i = 0; i < rows; ++i) {
            int cols = array[0].length;
            for (int j = 0; j < cols; ++j) {
                array[i][j] = (float)matrix[i][j];
            }
        }
        return array;
    }

    public static float[] toFloatArray(Collection<Float> c) {
        float[] array = new float[c.size()];
        int index = 0;
        for (float value : c) {
            array[index++] = value;
        }
        return array;
    }

    public static int[] toIntArray(Collection<Integer> c) {
        int[] array = new int[c.size()];
        int index = 0;
        for (int value : c) {
            array[index++] = value;
        }
        return array;
    }

    public static List<Integer> toList(final int[] array) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return array[index];
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static String[] toStringArray(Object[] array) {
        String[] copy = new String[array.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = (String)array[i];
        }
        return copy;
    }

    public static String truncate(String text, int length) {
        if (text != null && text.length() > length) {
            text = text.substring(0, length - 3) + "...";
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeCls(ClassVector cv, String pathname, boolean checkFileExtension) throws IOException {
        FileOutputStream fos = null;
        try {
            ClsWriter writer = new ClsWriter();
            if (checkFileExtension) {
                pathname = writer.checkFileExtension(pathname);
            }
            fos = new FileOutputStream(pathname);
            writer.write(cv, fos);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioe) {}
        }
        return pathname;
    }

    private static void _listDirs(File rootDir, Set<File> set, final FileFilter dirFilter, boolean recursive) throws InterruptedException {
        File[] dirs;
        for (File f : dirs = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && dirFilter.accept(pathname);
            }
        })) {
            if (set.contains(f)) continue;
            set.add(f);
            if (!recursive) continue;
            IOUtil._listDirs(f, set, dirFilter, recursive);
        }
    }

    private static void addToArray(String[] range, TIntArrayList indices) {
        int last;
        int first = ParserHelper.parseInt(range[0].trim());
        int by = 1;
        int lastIndex = 1;
        if (range.length == 3) {
            by = ParserHelper.parseInt(range[2].trim());
            lastIndex = 2;
        }
        if (first <= (last = ParserHelper.parseInt(range[lastIndex].trim()))) {
            for (int i = first; i <= last; i += by) {
                indices.add(i);
            }
        } else {
            for (int i = first; i >= last; i -= by) {
                indices.add(i);
            }
        }
    }

    private static void listFiles(File rootDir, FileFilter fileFilter, FileFilter dirFilter, Set<File> set, ProgressNotifier progressNotifier, boolean recursive) throws InterruptedException {
        progressNotifier.setMessage("Searching " + rootDir);
        File[] filesAndDirs = rootDir.listFiles();
        if (filesAndDirs == null) {
            System.err.println("Unable to list files in " + rootDir);
            filesAndDirs = new File[]{};
        }
        ArrayList<File> dirs = new ArrayList<File>();
        for (File file : filesAndDirs) {
            if (!file.isDirectory()) {
                if (!fileFilter.accept(file)) continue;
                set.add(file);
                continue;
            }
            dirs.add(file);
        }
        if (recursive) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            for (File dir : dirs) {
                if (dirFilter != null && !dirFilter.accept(dir)) continue;
                IOUtil.listFiles(dir, fileFilter, dirFilter, set, progressNotifier, recursive);
            }
        }
    }

    static {
        clsReader = new ClsReader();
        COMMA_PATTERN = Pattern.compile(",");
        TAB_PATTERN = Pattern.compile("\t");
        StringBuilder buf = new StringBuilder("[");
        for (char c : PROHIBITED_WINDOWS_FILE_NAME_CHARS) {
            buf.append(c);
        }
        buf.append("]");
        PROHIBITED_WINDOWS_FILE_NAME_PATTERN = buf.toString();
    }
}

