/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

public class ParserHelper {
    public static float parseFloat(String s) throws NumberFormatException {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException nfe) {
            if (s.equals("Inf")) {
                return Float.POSITIVE_INFINITY;
            }
            if (s.equals("-Inf")) {
                return Float.NEGATIVE_INFINITY;
            }
            throw nfe;
        }
    }

    public static float parseFloatNaN(String s) throws NumberFormatException {
        if (ParserHelper.isNaN(s)) {
            return Float.NaN;
        }
        return ParserHelper.parseFloat(s);
    }

    public static double parseDoubleNaN(String s) throws NumberFormatException {
        if (ParserHelper.isNaN(s)) {
            return Double.NaN;
        }
        return ParserHelper.parseDouble(s);
    }

    public static double parseDouble(String s) throws NumberFormatException {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            if (s.equals("Inf")) {
                return Double.POSITIVE_INFINITY;
            }
            if (s.equals("-Inf")) {
                return Double.NEGATIVE_INFINITY;
            }
            throw nfe;
        }
    }

    public static int parseInt(String s) throws NumberFormatException {
        return Integer.parseInt(s);
    }

    private static boolean isNaN(String s) {
        return "#N/A".equals(s) || "".equals(s) || "NA".equalsIgnoreCase(s) || "NAN".equalsIgnoreCase(s) || "?".equalsIgnoreCase(s) || "NULL".equalsIgnoreCase(s) || s == null;
    }
}

