/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.broadinstitute.genee.io.util.StreamCopier;

public class RInterpreter {
    private Thread errorReader;
    private Thread outputReader;
    private Process process;
    private OutputStream stdin;

    public static void main(String[] args) throws Exception {
        String rHome = args[0];
        RInterpreter r = new RInterpreter(rHome);
        String rSourceFile = args[1];
        String method = args[2];
        r.source(new File(rSourceFile));
        String[] methodArgs = new String[args.length - 3];
        System.arraycopy(args, 3, methodArgs, 0, methodArgs.length);
        r.runMethod(method, methodArgs);
        r.quit();
    }

    protected static String fixPath(String path) {
        return path.replace('\\', '/');
    }

    protected static void sendCmd(OutputStream stdin, String command) throws IOException {
        stdin.write(command.getBytes());
        stdin.flush();
    }

    protected static Thread streamCopier(InputStream is, PrintStream os) {
        return new StreamCopier(is, os);
    }

    private static String[] createCommandLine(String pathToRHome) {
        String[] commandLine = null;
        boolean runningOnWindows = System.getProperty("os.name").startsWith("Windows");
        if (runningOnWindows) {
            if (pathToRHome == null) {
                File[] files;
                File rDirectory = new File("C:\\Program Files\\R");
                boolean foundR = false;
                if (rDirectory.exists() && rDirectory.isDirectory() && (files = rDirectory.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().startsWith("R-");
                    }
                })).length > 0) {
                    Arrays.sort(files, new Comparator<File>(){

                        @Override
                        public int compare(File o1, File o2) {
                            return new Date(o1.lastModified()).compareTo(new Date(o2.lastModified()));
                        }
                    });
                    try {
                        pathToRHome = files[files.length - 1].getCanonicalPath();
                        foundR = true;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                commandLine = foundR ? new String[]{"cmd", "/c", pathToRHome + "\\bin\\Rterm"} : new String[]{"cmd", "/c", "Rterm"};
            } else {
                commandLine = new String[]{"cmd", "/c", pathToRHome + "\\bin\\Rterm"};
            }
        } else {
            commandLine = pathToRHome == null ? new String[]{"R"} : new String[]{pathToRHome + "/bin/R"};
        }
        return commandLine;
    }

    public RInterpreter(String pathToRHome) throws Exception {
        this(RInterpreter.createCommandLine(pathToRHome));
    }

    RInterpreter(String[] commandLine) throws Exception {
        String[] rFlags = new String[]{"--no-save", "--quiet", "--slave", "--no-restore"};
        String[] fullCommandLine = new String[commandLine.length + rFlags.length];
        System.arraycopy(commandLine, 0, fullCommandLine, 0, commandLine.length);
        System.arraycopy(rFlags, 0, fullCommandLine, commandLine.length, rFlags.length);
        this.process = Runtime.getRuntime().exec(fullCommandLine, null, null);
        this.outputReader = RInterpreter.streamCopier(this.process.getInputStream(), System.out);
        this.errorReader = RInterpreter.streamCopier(this.process.getErrorStream(), System.err);
        this.outputReader.start();
        this.errorReader.start();
        this.stdin = this.process.getOutputStream();
    }

    public void quit() throws Exception {
        RInterpreter.sendCmd(this.stdin, "q(save=\"no\")\n");
        this.stdin.close();
        this.outputReader.join();
        this.errorReader.join();
        this.process.waitFor();
    }

    public void read(InputStream is) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String s = null;
        while ((s = br.readLine()) != null) {
            RInterpreter.sendCmd(this.stdin, s + "\n");
        }
    }

    public void runMethod(String methodName, String[] args) throws Exception {
        RInterpreter.sendCmd(this.stdin, "output <- " + methodName);
        RInterpreter.sendCmd(this.stdin, "(");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                RInterpreter.sendCmd(this.stdin, ", ");
            }
            RInterpreter.sendCmd(this.stdin, "'" + RInterpreter.fixPath(args[i]) + "'");
        }
        RInterpreter.sendCmd(this.stdin, ")\n");
    }

    public void source(File file) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String s = null;
        while ((s = br.readLine()) != null) {
            RInterpreter.sendCmd(this.stdin, s + "\n");
        }
        br.close();
    }

    public void source(InputStream is) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String s = null;
        while ((s = br.readLine()) != null) {
            RInterpreter.sendCmd(this.stdin, s + "\n");
        }
    }

    public void source(String text) throws Exception {
        RInterpreter.sendCmd(this.stdin, text);
    }
}

