/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.io.util.Formatter;

public class TableModelWriter {
    public void write(TableModel tableModel, OutputStream os) throws IOException {
        PrintWriter pw = new PrintWriter(os);
        int columns = tableModel.getColumnCount();
        for (int j = 0; j < columns; ++j) {
            if (j > 0) {
                pw.print("\t");
            }
            pw.print(tableModel.getColumnName(j));
        }
        pw.println();
        int rows = tableModel.getRowCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                Object value;
                if (j > 0) {
                    pw.print("\t");
                }
                if ((value = tableModel.getValueAt(i, j)) instanceof Number) {
                    value = Formatter.format((Number)value);
                } else if (value == null) {
                    value = "";
                }
                pw.print(value);
            }
            pw.println();
        }
        pw.flush();
    }
}

