/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.luminex.AbstractPlateOperation;
import org.broadinstitute.genee.luminex.LuminexImporter;
import org.broadinstitute.genee.luminex.SubtractBackground;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public abstract class AbstractLuminexProcessor {
    protected boolean subtractBackground;
    protected CollapseMethodOption collapseReplicatesMethod;
    protected int collapseReplicatesTrimmedMeanS;
    protected int collapseReplicatesTrimmedMeanL;
    protected String[] namesForReplicates = new String[]{"concentration"};
    protected Object[] plateNames;
    protected String[] concentrationMetadataNames;
    protected String plateMetadataName;
    protected AbstractPlateOperation subtractBackgroundFunction;
    protected RowMajorArray2DDataset dataset;
    protected Map<Object, TIntArrayList> plateNameToRowIndices;

    protected AbstractLuminexProcessor() {
    }

    protected void sort(Project project) {
        Dataset dataset = project.getSortedFilteredDataset();
        if (dataset.getRowMetadata().getColumnIndex(this.plateMetadataName) != -1) {
            ArrayList<SortKeys.VectorSortKey> sortKeys = new ArrayList<SortKeys.VectorSortKey>();
            sortKeys.add(new SortKeys.VectorSortKey(this.plateMetadataName, SortOrder.ASCENDING, true));
            for (String key : this.concentrationMetadataNames) {
                if (dataset.getRowMetadata().getColumnIndex(key) == -1) {
                    return;
                }
                sortKeys.add(new SortKeys.VectorSortKey(key, SortOrder.ASCENDING, true));
            }
            project.setRowSortOrder(sortKeys);
        }
    }

    protected ProjectGENEEResultTreeNode createNode(List<ProjectGENEEResultTreeNode> results, Dataset d, String name, ArrayList<RowMajorArray2DDataset> datasetProcessingSteps, History history) {
        RowMajorArray2DDataset copy = DatasetUtil.deepCopy(d);
        copy.setName(name);
        DefaultProject project = new DefaultProject(copy);
        this.sort(project);
        ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(project, history);
        node.setAutoOpen("Collapsed".equals(name));
        results.add(node);
        return node;
    }

    public void setBackgroundSubtract(boolean subtractBackgroud, String backgroundSubtractFieldName, Object backgroundSubtractFieldValue, CollapseMethodOption backgroundSubtractionCollapseMethod, int subtractBackgroundTrimmedMeanS, int subtractBackgroundTrimmedMeanL) {
        this.subtractBackground = subtractBackgroud;
        if (this.subtractBackground) {
            this.subtractBackgroundFunction = new SubtractBackground((Dataset)this.dataset, backgroundSubtractFieldName, backgroundSubtractFieldValue);
            this.subtractBackgroundFunction.setPlateToRowIndicesMap(this.plateNameToRowIndices);
            this.subtractBackgroundFunction.setCollapseMethod(backgroundSubtractionCollapseMethod);
            this.subtractBackgroundFunction.setTrimmedMeanL(subtractBackgroundTrimmedMeanL);
            this.subtractBackgroundFunction.setTrimmedMeanS(subtractBackgroundTrimmedMeanS);
        }
    }

    public void setCollapseReplicatesMethod(CollapseMethodOption collapseReplicatesMethod, int s, int l, String[] namesForReplicates) {
        this.collapseReplicatesMethod = collapseReplicatesMethod;
        this.collapseReplicatesTrimmedMeanS = s;
        this.collapseReplicatesTrimmedMeanL = l;
        this.namesForReplicates = namesForReplicates;
    }

    public void setMetadataNames(String[] concentrationMetadataNames, String plateMetadataName) {
        this.concentrationMetadataNames = concentrationMetadataNames;
        if (plateMetadataName == null) {
            System.err.println("Warning: plate field name is null");
            plateMetadataName = "";
        }
        this.plateMetadataName = plateMetadataName;
        this.plateNameToRowIndices = LuminexImporter.createPlateNameToRowIndices(plateMetadataName, this.dataset);
        this.plateNames = this.plateNameToRowIndices.keySet().toArray(new Object[0]);
    }

    public void setProject(Project p) {
        this.dataset = DatasetUtil.deepCopy(p.getOriginalDataset());
    }
}

