/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex;

import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.heatmap.DefaultToolTipProvider;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class CollapsedToolTipProvider
extends DefaultToolTipProvider {
    private List<RowMajorArray2DDataset> datasetProcessingSteps;
    private Map<Identifier, TIntArrayList> replicateMap;
    private String[] collapseToFields;
    private Project project;

    public CollapsedToolTipProvider(Project project, List<RowMajorArray2DDataset> datasetProcessingSteps, Map<Identifier, TIntArrayList> replicateMap, String[] collapseToFields) {
        this.project = project;
        this.datasetProcessingSteps = datasetProcessingSteps;
        this.replicateMap = replicateMap;
        this.collapseToFields = collapseToFields;
    }

    @Override
    protected void update(Dataset dataset, int rowIndex, int columnIndex, List<Map.Entry> entries) {
        Object[] array = new Object[this.collapseToFields.length];
        rowIndex = this.project.convertViewRowIndexToModel(rowIndex);
        columnIndex = this.project.convertViewColumnIndexToModel(columnIndex);
        for (int i = 0; i < this.collapseToFields.length; ++i) {
            array[i] = dataset.getRowMetadata().get(this.collapseToFields[i]).getValue(rowIndex);
        }
        TIntArrayList rowIndices = this.replicateMap.get(new Identifier<Object>(array));
        for (int i = 0; i < this.datasetProcessingSteps.size(); ++i) {
            Dataset previousDataset = this.datasetProcessingSteps.get(i);
            String name = i == 0 ? "Original data" : previousDataset.getName();
            name = i + 1 + ". " + name;
            for (int j = 0; j < rowIndices.size(); ++j) {
                entries.add(new BasicMapEntry<String>(name, Formatter.format(previousDataset.getValue(rowIndices.getQuick(j), columnIndex))));
            }
        }
    }
}

