/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex.ui.input;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.CheckBoxList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;
import org.broadinstitute.genee.matrix.Dataset;

public class CollapseReplicatesPanel
extends JPanel {
    private JComboBox comboBox;
    private static final String sParameter = "The number of smallest elements to trim away (s >= 0)";
    private static final String lParameter = "The number of largest elements to trim away (l >= 0)";
    private JTextField sTextField = new JTextField(6);
    private JTextField lTextField = new JTextField(6);
    private DefineReplicates defineReplicates;
    private List<String> rowMetaDataReplicateNames = new ArrayList<String>();

    public CollapseReplicatesPanel(Dataset dataset) {
        JPanel topPanel = new JPanel((LayoutManager)new FormLayout("pref, 2dlu, pref, 2dlu, pref", "pref"));
        CellConstraints cc = new CellConstraints();
        this.comboBox = UIUtil.createComboBox((Object[])new CollapseMethodOption[]{CollapseMethodOption.MEAN, CollapseMethodOption.MEDIAN, CollapseMethodOption.TRIMMED_MEAN});
        this.comboBox.setSelectedItem((Object)CollapseMethodOption.MEDIAN);
        topPanel.add((Component)new JLabel("Collapse replicates to single value by taking"), cc.xy(1, 1));
        topPanel.add((Component)this.comboBox, cc.xy(3, 1));
        topPanel.add((Component)new JLabel("of replicates"), cc.xy(5, 1));
        final JPanel bottomPanel = new JPanel((LayoutManager)new FormLayout("5dlu, pref, 2dlu, pref", "pref, pref"));
        bottomPanel.add((Component)new JLabel(sParameter), cc.xy(2, 1));
        bottomPanel.add((Component)this.sTextField, cc.xy(4, 1));
        bottomPanel.add((Component)new JLabel(lParameter), cc.xy(2, 2));
        bottomPanel.add((Component)this.lTextField, cc.xy(4, 2));
        bottomPanel.setVisible(false);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                bottomPanel.setVisible(CollapseReplicatesPanel.this.comboBox.getSelectedItem() == CollapseMethodOption.TRIMMED_MEAN);
            }
        });
        this.setLayout((LayoutManager)new FormLayout("pref", "pref, pref, pref"));
        this.add((Component)topPanel, cc.xy(1, 1));
        this.add((Component)bottomPanel, cc.xy(1, 2));
        this.defineReplicates = new DefineReplicates(dataset);
        JButton defineReplicatesBtn = new JButton("Define Replicates\u2026");
        defineReplicatesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollapseReplicatesPanel.this.defineReplicates.show();
            }
        });
        JPanel p = new JPanel();
        p.add(defineReplicatesBtn);
        this.add((Component)p, cc.xy(1, 3));
    }

    public String[] getRowMetadataReplicateNames() {
        return this.rowMetaDataReplicateNames.toArray(new String[0]);
    }

    public CollapseMethodOption getCollapseMethod() {
        return (CollapseMethodOption)((Object)this.comboBox.getSelectedItem());
    }

    public int getTrimmedMeanS() {
        return Integer.parseInt(this.sTextField.getText().trim());
    }

    public int getTrimmedMeanL() {
        return Integer.parseInt(this.lTextField.getText().trim());
    }

    private class DefineReplicates {
        private CheckBoxList list;
        private JScrollPane scrollPane;
        private GENEEWindow replicateDialog;
        private DefaultListModel model = new DefaultListModel();

        public DefineReplicates(Dataset dataset) {
            HashSet<String> ignore = new HashSet<String>();
            ignore.add("Description");
            ignore.add("plate row");
            ignore.add("plate column");
            for (int i = 0; i < dataset.getRowMetadata().getMetadataCount(); ++i) {
                if (ignore.contains(dataset.getRowMetadata().getColumnName(i))) continue;
                this.model.addElement(dataset.getRowMetadata().getColumnName(i));
                if (dataset.getRowMetadata().getColumnName(i).toLowerCase().startsWith("error")) continue;
                CollapseReplicatesPanel.this.rowMetaDataReplicateNames.add(dataset.getRowMetadata().getColumnName(i));
            }
            if (this.model.getSize() == 0) {
                UIUtil.showMessageDialog(UIUtil.getCurrentFrame(), "No metadata loaded");
                return;
            }
            this.list = new CheckBoxList((ListModel)this.model);
            this.scrollPane = new JScrollPane((Component)this.list);
        }

        public void show() {
            this.list.getCheckBoxListSelectionModel().clearSelection();
            for (String s : CollapseReplicatesPanel.this.rowMetaDataReplicateNames) {
                int index = this.model.indexOf(s);
                this.list.getCheckBoxListSelectionModel().addSelectionInterval(index, index);
            }
            if (this.replicateDialog == null) {
                this.createReplicateDialog();
            }
            this.replicateDialog.setVisible(true);
        }

        private void createReplicateDialog() {
            this.replicateDialog = Application.createDialog(UIUtil.getWindowForComponent((Component)this.list), "Define Replicates");
            JPanel northPanel = new JPanel(new BorderLayout());
            northPanel.add((Component)new JLabel("Select metadata that defines a replicate"), "North");
            JPanel buttonPanel = new JPanel((LayoutManager)new FormLayout("p, 6px, p", "p"));
            JButton selectAllButton = new JButton("Select All");
            selectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefineReplicates.this.list.selectAll();
                }
            });
            JButton selectNoneButton = new JButton("Select None");
            selectNoneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefineReplicates.this.list.selectNone();
                }
            });
            buttonPanel.add((Component)selectAllButton, CC.xy((int)1, (int)1));
            buttonPanel.add((Component)selectNoneButton, CC.xy((int)3, (int)1));
            northPanel.add(buttonPanel);
            this.replicateDialog.getContentPane().add((Component)northPanel, "North");
            this.replicateDialog.getContentPane().add(this.scrollPane);
            this.replicateDialog.getContentPane().add((Component)UIUtil.buildOKCancelBar(this.replicateDialog, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefineReplicates.this.replicateDialog.setVisible(false);
                    CollapseReplicatesPanel.this.rowMetaDataReplicateNames.clear();
                    Object[] values = CollapseReplicatesPanel.this.defineReplicates.list.getCheckBoxListSelectedValues();
                    for (int i = 0; i < values.length; ++i) {
                        CollapseReplicatesPanel.this.rowMetaDataReplicateNames.add((String)values[i]);
                    }
                }
            }), "South");
            this.replicateDialog.pack();
        }
    }
}

