/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex.ui.rnai;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.broadinstitute.genee.gui.DatasetAutocomplete;
import org.broadinstitute.genee.gui.DelimListDataIntelliHints;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.luminex.LuminexImporter;
import org.broadinstitute.genee.luminex.ui.input.InputPanel;
import org.broadinstitute.genee.luminex.ui.rnai.RNAiProcessor;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;
import org.broadinstitute.genee.matrix.Dataset;

public class PRISMRNAiInputGUI {
    private JTextField puroPlusDividedByPuroMinusCensorTextField;
    private JRadioButton noScaling;
    private JRadioButton customScaleTo;
    private JTextField[] customScaleToTextFields;
    private JRadioButton[] customPuroPlus;
    private JRadioButton[] customPuroMinus;
    private InputPanel inputPanel = new InputPanel();
    private JTextField lowSignalTextFieldHairpinTextField;
    private Project project;
    private JTextField lowSignalCensorValueTextField;
    private JComboBox lowSignalPuroStatusComboBox;
    private JTextField floorTextField;
    private JCheckBox floorCheckBox;
    private JTextField ceilingTextField;
    private JCheckBox ceilingCheckBox;
    private Dataset dataset;
    private JPanel scaleToPanel;
    private Map<Object, TIntArrayList> plateNameToRowIndices;

    private void createScaleToPanel() {
        KeyListener kl = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                PRISMRNAiInputGUI.this.customScaleTo.setSelected(true);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        String plateNameField = this.inputPanel.getPlateMetadaFieldNameName();
        this.plateNameToRowIndices = LuminexImporter.createPlateNameToRowIndices(plateNameField, this.dataset);
        Object[] plateNames = new Object[this.plateNameToRowIndices.size()];
        int plateIndex = 0;
        for (Object obj : this.plateNameToRowIndices.keySet()) {
            plateNames[plateIndex++] = Formatter.toString(obj);
        }
        this.scaleToPanel.removeAll();
        this.scaleToPanel.setLayout((LayoutManager)new FormLayout("20px, pref", UIUtil.createRowStringForFormLayout(2 + plateNames.length)));
        CellConstraints cc = new CellConstraints();
        this.scaleToPanel.add((Component)this.noScaling, cc.xy(2, 1));
        this.scaleToPanel.add((Component)this.customScaleTo, cc.xy(2, 3));
        this.customScaleToTextFields = new JTextField[plateNames.length];
        this.customPuroPlus = new JRadioButton[plateNames.length];
        this.customPuroMinus = new JRadioButton[plateNames.length];
        int i = 0;
        int row = 5;
        while (i < plateNames.length) {
            this.customScaleToTextFields[i] = new JTextField(10);
            final List<String> plates = this.getValuesForPlate(plateNames[i]);
            new DelimListDataIntelliHints(this.customScaleToTextFields[i]){

                @Override
                public Collection<String> getMatches(String text) {
                    ArrayList<String> matches = new ArrayList<String>();
                    boolean caseSensitive = this.isCaseSensitive();
                    Iterator i$ = plates.iterator();
                    while (i$.hasNext()) {
                        String id;
                        String _id = id = (String)i$.next();
                        if (!caseSensitive) {
                            _id = _id.toLowerCase();
                        }
                        if (!_id.startsWith(text)) continue;
                        matches.add(id);
                    }
                    Collections.sort(matches, String.CASE_INSENSITIVE_ORDER);
                    return matches;
                }
            };
            this.customScaleToTextFields[i].addKeyListener(kl);
            this.customPuroPlus[i] = new JRadioButton("Puro +");
            this.customPuroMinus[i] = new JRadioButton("Puro -", true);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.customPuroPlus[i]);
            bg.add(this.customPuroMinus[i]);
            JPanel p = new JPanel((LayoutManager)new FormLayout("20px, pref, 2dlu, pref, pref, pref", "pref"));
            p.add((Component)new JLabel(plateNames[i].toString()), cc.xy(2, 1));
            p.add((Component)this.customScaleToTextFields[i], cc.xy(4, 1));
            p.add((Component)this.customPuroPlus[i], cc.xy(5, 1));
            p.add((Component)this.customPuroMinus[i], cc.xy(6, 1));
            this.scaleToPanel.add((Component)p, cc.xy(2, row));
            ++i;
            row += 2;
        }
        this.scaleToPanel.revalidate();
        this.scaleToPanel.repaint();
    }

    public PRISMRNAiInputGUI(Project project) {
        this.project = project;
        this.dataset = project.getOriginalDataset();
        CellConstraints cc = new CellConstraints();
        this.inputPanel.addBackgroundSubtraction(project.getSortedFilteredDataset());
        this.inputPanel.addMetadataInputFields(this.dataset, false);
        this.inputPanel.nextRow();
        this.inputPanel.addScaleToWellSignalFraction();
        this.inputPanel.nextRow();
        JPanel hairpinMinusBackgroundPanel = new JPanel((LayoutManager)new FormLayout("pref, pref, 2dlu, pref, 2dlu, pref, pref", "pref"));
        this.lowSignalTextFieldHairpinTextField = new JTextField(10);
        hairpinMinusBackgroundPanel.add((Component)new JLabel("Censor cell line on plate if "), cc.xy(1, 1));
        hairpinMinusBackgroundPanel.add((Component)this.lowSignalTextFieldHairpinTextField, cc.xy(2, 1));
        this.lowSignalPuroStatusComboBox = UIUtil.createComboBox();
        this.lowSignalPuroStatusComboBox.addItem("Puro-");
        this.lowSignalPuroStatusComboBox.addItem("Puro+");
        this.lowSignalPuroStatusComboBox.addItem("-1");
        hairpinMinusBackgroundPanel.add((Component)this.lowSignalPuroStatusComboBox, cc.xy(4, 1));
        hairpinMinusBackgroundPanel.add((Component)new JLabel("minus background is less than "), cc.xy(6, 1));
        this.lowSignalCensorValueTextField = new JTextField(10);
        hairpinMinusBackgroundPanel.add((Component)this.lowSignalCensorValueTextField, cc.xy(7, 1));
        this.inputPanel.getProcessingOptionsPanel().add((Component)hairpinMinusBackgroundPanel, cc.xy(1, this.inputPanel.getFormLayout().getRowCount()));
        this.inputPanel.nextRow();
        this.puroPlusDividedByPuroMinusCensorTextField = new JTextField(10);
        JPanel censorPanel = new JPanel((LayoutManager)new FormLayout("pref, pref", "pref"));
        censorPanel.add((Component)new JLabel("Censor hairpins whose puro+ score divided by puro- score is less than "), cc.xy(1, 1));
        censorPanel.add((Component)this.puroPlusDividedByPuroMinusCensorTextField, cc.xy(2, 1));
        this.inputPanel.getProcessingOptionsPanel().add((Component)censorPanel, cc.xy(1, this.inputPanel.getFormLayout().getRowCount()));
        this.inputPanel.nextRow();
        JLabel rnaiScaleToLabel = new JLabel("Scale to ");
        this.inputPanel.nextRow();
        this.inputPanel.getProcessingOptionsPanel().add((Component)rnaiScaleToLabel, cc.xy(1, this.inputPanel.getFormLayout().getRowCount()));
        this.inputPanel.nextRow();
        new DatasetAutocomplete(this.lowSignalTextFieldHairpinTextField, project.getOriginalDataset(), true);
        this.customScaleTo = new JRadioButton("median of custom shRNAs (separate multiple shRNAs with a comma)");
        this.noScaling = new JRadioButton("no scaling");
        ButtonGroup scaleBtnGroup = new ButtonGroup();
        scaleBtnGroup.add(this.customScaleTo);
        scaleBtnGroup.add(this.noScaling);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = !PRISMRNAiInputGUI.this.noScaling.isSelected();
                for (int i = 0; i < PRISMRNAiInputGUI.this.customScaleToTextFields.length; ++i) {
                    PRISMRNAiInputGUI.this.customScaleToTextFields[i].setEnabled(enabled);
                    PRISMRNAiInputGUI.this.customPuroPlus[i].setEnabled(enabled);
                    PRISMRNAiInputGUI.this.customPuroMinus[i].setEnabled(enabled);
                }
            }
        };
        this.customScaleTo.addActionListener(l);
        this.noScaling.addActionListener(l);
        this.scaleToPanel = new JPanel();
        this.inputPanel.getPlateMetadataNameInputField().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PRISMRNAiInputGUI.this.createScaleToPanel();
            }
        });
        this.createScaleToPanel();
        this.inputPanel.getProcessingOptionsPanel().add((Component)this.scaleToPanel, cc.xy(1, this.inputPanel.getFormLayout().getRowCount()));
        this.inputPanel.nextRow();
        JPanel floorPanel = new JPanel((LayoutManager)new FormLayout("pref, 2dlu, pref", "pref"));
        this.floorTextField = new JTextField(10);
        this.floorCheckBox = new JCheckBox("Apply floor", false);
        this.floorTextField.setEnabled(false);
        this.floorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PRISMRNAiInputGUI.this.floorTextField.setEnabled(PRISMRNAiInputGUI.this.floorCheckBox.isSelected());
            }
        });
        floorPanel.add((Component)this.floorCheckBox, cc.xy(1, 1));
        floorPanel.add((Component)this.floorTextField, cc.xy(3, 1));
        this.inputPanel.getProcessingOptionsPanel().add((Component)floorPanel, cc.xy(1, this.inputPanel.getFormLayout().getRowCount()));
        this.inputPanel.nextRow();
        JPanel ceilingPanel = new JPanel((LayoutManager)new FormLayout("pref, 2dlu, pref", "pref"));
        this.ceilingTextField = new JTextField(10);
        this.ceilingCheckBox = new JCheckBox("Apply ceiling", false);
        this.ceilingTextField.setEnabled(false);
        this.ceilingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PRISMRNAiInputGUI.this.ceilingTextField.setEnabled(PRISMRNAiInputGUI.this.ceilingCheckBox.isSelected());
            }
        });
        ceilingPanel.add((Component)this.ceilingCheckBox, cc.xy(1, 1));
        ceilingPanel.add((Component)this.ceilingTextField, cc.xy(3, 1));
        this.inputPanel.getProcessingOptionsPanel().add((Component)ceilingPanel, cc.xy(1, this.inputPanel.getFormLayout().getRowCount()));
        this.inputPanel.nextRow();
        this.inputPanel.addCollapseReplicates(project.getSortedFilteredDataset());
    }

    public JPanel getPanel() {
        return this.inputPanel.getProcessingOptionsPanel();
    }

    public void process() {
        int lowSignalHairpinPuroStatus;
        boolean scaleToWellSignalFraction;
        RNAiProcessor processor = new RNAiProcessor();
        String[] concOrPuroField = this.inputPanel.getConcentrationOrPuroMetadataFieldName();
        String plateField = this.inputPanel.getPlateMetadaFieldNameName();
        processor.setProject(this.project);
        processor.setMetadataNames(concOrPuroField, plateField);
        boolean subtractBackgroud = this.inputPanel.isSubtractBackground();
        CollapseMethodOption backgroundSubtractionCollapseMethod = this.inputPanel.getBackgroundSubtractionCollapseMethod();
        int bgSubtractTrimmedMeanS = backgroundSubtractionCollapseMethod.equals((Object)CollapseMethodOption.TRIMMED_MEAN) ? this.inputPanel.getSubtractBackgroundTrimmedMeanS() : -1;
        int bgSubtractTrimmedMeanL = backgroundSubtractionCollapseMethod.equals((Object)CollapseMethodOption.TRIMMED_MEAN) ? this.inputPanel.getSubtractBackgroundTrimmedMeanL() : -1;
        processor.setBackgroundSubtract(subtractBackgroud, this.inputPanel.getBackgroundSubtractPanel().getCompoundMetadataFieldName(), this.inputPanel.getBackgroundSubtractMatchValue(), backgroundSubtractionCollapseMethod, bgSubtractTrimmedMeanS, bgSubtractTrimmedMeanL);
        processor.setHairpinFieldName(this.inputPanel.getBackgroundSubtractPanel().getCompoundMetadataFieldName());
        processor.scaleToWellSignalFraction = scaleToWellSignalFraction = this.inputPanel.isScaleToWellSignalFraction();
        CollapseMethodOption collapseReplicatesMethod = this.inputPanel.getCollapseReplicatesMethod();
        String[] rowMetadataReplicateNames = this.inputPanel.getRowMetadataReplicateNames();
        int replicatesSubtractTrimmedMeanS = collapseReplicatesMethod.equals((Object)CollapseMethodOption.TRIMMED_MEAN) ? this.inputPanel.getCollapseReplicatesTrimmedMeanS() : -1;
        int replicatesSubtractTrimmedMeanL = collapseReplicatesMethod.equals((Object)CollapseMethodOption.TRIMMED_MEAN) ? this.inputPanel.getCollapseReplicatesTrimmedMeanL() : -1;
        processor.setCollapseReplicatesMethod(collapseReplicatesMethod, replicatesSubtractTrimmedMeanS, replicatesSubtractTrimmedMeanL, rowMetadataReplicateNames);
        String lowSignalCensorValueString = this.lowSignalCensorValueTextField.getText().trim();
        boolean doLowSignalCensoring = !lowSignalCensorValueString.equals("");
        float lowSignalCensorValue = !doLowSignalCensoring ? Float.NaN : ParserHelper.parseFloat(lowSignalCensorValueString);
        String lowSignalHairpinPuroStatusString = (String)this.lowSignalPuroStatusComboBox.getSelectedItem();
        if (lowSignalHairpinPuroStatusString.equals("Puro+")) {
            lowSignalHairpinPuroStatus = 1;
        } else if (lowSignalHairpinPuroStatusString.equals("Puro-")) {
            lowSignalHairpinPuroStatus = 0;
        } else if (lowSignalHairpinPuroStatusString.equals("-1")) {
            lowSignalHairpinPuroStatus = -1;
        } else {
            throw new RuntimeException();
        }
        String lowSignalHairpin = this.lowSignalTextFieldHairpinTextField.getText().trim();
        if (doLowSignalCensoring && lowSignalHairpin.equals("")) {
            throw new RuntimeException("Please enter a value for the low signal hairpin field.");
        }
        processor.setLowSignalFilterParameter(lowSignalHairpin, lowSignalCensorValue, lowSignalHairpinPuroStatus);
        String puroPlusDividedByPuroMinusCensorValue = this.puroPlusDividedByPuroMinusCensorTextField.getText().trim();
        processor.puroPlusDividedByPuroMinusCensorValue = puroPlusDividedByPuroMinusCensorValue.equals("") ? Float.NaN : ParserHelper.parseFloat(puroPlusDividedByPuroMinusCensorValue);
        processor.customScaleTo = this.customScaleTo.isSelected();
        ArrayList<String[]> customScaleToValues = new ArrayList<String[]>();
        ArrayList<Integer> customScaleToPuroStatusList = new ArrayList<Integer>();
        processor.customScaleToValues = customScaleToValues;
        processor.customScaleToPuroStatus = customScaleToPuroStatusList;
        for (int i = 0; i < this.customScaleToTextFields.length; ++i) {
            String field = this.customScaleToTextFields[i].getText().trim();
            String[] customScaleToFields = field.split(",");
            for (int j = 0; j < customScaleToFields.length; ++j) {
                customScaleToFields[j] = customScaleToFields[j].trim();
            }
            customScaleToValues.add(customScaleToFields);
            customScaleToPuroStatusList.add(this.customPuroPlus[i].isSelected() ? 1 : 0);
        }
        processor.floor = !this.floorCheckBox.isSelected() ? Float.NaN : ParserHelper.parseFloat(this.floorTextField.getText().trim());
        processor.ceiling = !this.ceilingCheckBox.isSelected() ? Float.NaN : ParserHelper.parseFloat(this.ceilingTextField.getText().trim());
        processor.process();
    }

    private List<String> getValuesForPlate(Object plate) {
        TIntArrayList indices = this.plateNameToRowIndices.get(plate);
        if (indices == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(indices.size());
        int size = indices.size();
        for (int i = 0; i < size; ++i) {
            int index = indices.getQuick(i);
            names.add(Formatter.toString(this.dataset.getRowMetadata().getValue(index, 0)));
        }
        return names;
    }
}

