/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.marker.permutation;

import cern.jet.random.engine.MersenneTwister;
import org.broadinstitute.genee.marker.permutation.Permuter;

public class PairedRandomPermuter
implements Permuter {
    private MersenneTwister random;
    private int[] classZeroIndices;
    private int[] classOneIndices;

    public PairedRandomPermuter(int[] classZeroIndices, int[] classOneIndices, int seed) {
        this.classZeroIndices = classZeroIndices;
        this.classOneIndices = classOneIndices;
        this.random = new MersenneTwister(seed);
        if (classZeroIndices.length != classOneIndices.length) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int[] next() {
        int[] newAssignments = new int[this.classZeroIndices.length * 2];
        int length = this.classZeroIndices.length;
        for (int i = 0; i < length; ++i) {
            if ((double)this.random.nextFloat() < 0.5) {
                newAssignments[this.classZeroIndices[i]] = 1;
                newAssignments[this.classOneIndices[i]] = 0;
                continue;
            }
            newAssignments[this.classZeroIndices[i]] = 0;
            newAssignments[this.classOneIndices[i]] = 1;
        }
        return newAssignments;
    }
}

