/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.adjust;

import org.broadinstitute.genee.math.stat.function.UnivariateFloatFunction;

public class LogScaleUnivariateFunction
implements UnivariateFloatFunction {
    public static final float LOG_TWO_CONSTANT = (float)Math.log(2.0);
    public static final float LOG_TEN_CONSTANT = (float)Math.log(10.0);
    private float constant = LOG_TWO_CONSTANT;

    @Override
    public float evaluate(float x) {
        if (x > 0.0f) {
            return (float)(Math.log(x) / (double)this.constant);
        }
        return 0.0f;
    }

    public void setBase(float base) {
        this.constant = (float)Math.log(base);
    }

    public static float log2(float d) {
        return (float)(d <= 0.0f ? 0.0 : Math.log(d) / (double)LOG_TWO_CONSTANT);
    }

    public static float log10(float d) {
        return (float)(d <= 0.0f ? 0.0 : Math.log(d) / (double)LOG_TEN_CONSTANT);
    }
}

