/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.adjust;

import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class ZScoreTransform
implements FloatListFunction {
    private float mean;
    private float standardDeviation;

    @Override
    public float evaluate(FloatList data) {
        this.mean = FloatListStatUtils.mean(data);
        this.standardDeviation = FloatListStatUtils.stdev(data, this.mean);
        int length = data.size();
        for (int j = 0; j < length; ++j) {
            float d = data.getValue(j);
            d = (d - this.mean) / this.standardDeviation;
            data.setValue(j, d);
        }
        return this.standardDeviation;
    }

    public float getMean() {
        return this.mean;
    }

    public float getStandardDeviation() {
        return this.standardDeviation;
    }

    public String toString() {
        return "Z-Score Transform";
    }
}

