/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.adjust.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Spearman;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.parameters.CheckBoxInputLabel;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.HiddenInputLabel;
import org.broadinstitute.genee.gui.parameters.TextFieldInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.math.adjust.AdjustDatasetOperation;
import org.broadinstitute.genee.math.adjust.Ceiling;
import org.broadinstitute.genee.math.adjust.Floor;
import org.broadinstitute.genee.math.adjust.InverseLog2;
import org.broadinstitute.genee.math.adjust.LogScale;
import org.broadinstitute.genee.math.stat.QuantileNorm;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class AdjustDataAlgorithmInput
extends AbstractInputAction {
    public static final String CEILING = "Ceiling";
    public static final String DIVIDE_COLUMN_BY = "Divide each column by";
    public static final String DIVIDE_ROW_BY = "Divide each row by";
    public static final String FLOOR = "Floor";
    public static final String INVERSE_LOG2 = "Inverse log\u2082";
    public static final String LOG2 = "Log\u2082";
    public static final String QUANTILE_NORMALIZATION = "Quantile normalization";
    public static final String RANK_NORMALIZATION = "Rank rormalization";
    public static final String SUBTRACT_COLUMN_BY = "Subtract from each column";
    public static final String SUBTRACT_ROW_BY = "Subtract from each row";

    public AdjustDataAlgorithmInput() {
        super("Adjust");
        this.setDescription("Select one or more operations. Operations are performed in order listed.");
        CheckBoxInputLabel ceilingLabel = new CheckBoxInputLabel(CEILING);
        this.addParameter(ceilingLabel, new TextFieldInputParameter().setDependsOn((JCheckBox)ceilingLabel.getComponent()), false);
        CheckBoxInputLabel floorLabel = new CheckBoxInputLabel(FLOOR);
        this.addParameter(floorLabel, new TextFieldInputParameter().setDependsOn((JCheckBox)floorLabel.getComponent()), false);
        this.addSpannedParameter(new HiddenInputLabel(LOG2), new CheckBoxParameter(LOG2), false);
        this.addSpannedParameter(new HiddenInputLabel(INVERSE_LOG2), new CheckBoxParameter(INVERSE_LOG2), false);
        this.addParameter(SUBTRACT_ROW_BY, new ComboBoxParameter(String.class), false);
        this.addParameter(DIVIDE_ROW_BY, new ComboBoxParameter(String.class), false);
        this.addParameter(SUBTRACT_COLUMN_BY, new ComboBoxParameter(String.class), false);
        this.addParameter(DIVIDE_COLUMN_BY, new ComboBoxParameter(String.class), false);
        this.addSpannedParameter(new HiddenInputLabel(QUANTILE_NORMALIZATION), new CheckBoxParameter(QUANTILE_NORMALIZATION), false);
        this.addSpannedParameter(new HiddenInputLabel(RANK_NORMALIZATION), new CheckBoxParameter(RANK_NORMALIZATION), false);
    }

    @Override
    public boolean beforeWindowShown() {
        Project p = Application.getProject();
        Dataset dataset = p.getOriginalDataset();
        List<String> columnNames = MetadataUtil.getColumnNames(dataset.getColumnMetadata(), Number.class);
        columnNames.add(0, "(None)");
        List<String> rowNames = MetadataUtil.getColumnNames(dataset.getRowMetadata(), Number.class);
        rowNames.add(0, "(None)");
        this.getInputPanelBuilder().getInputParameter(SUBTRACT_COLUMN_BY).init(columnNames.toArray());
        this.getInputPanelBuilder().getInputParameter(DIVIDE_COLUMN_BY).init(columnNames.toArray());
        this.getInputPanelBuilder().getInputParameter(SUBTRACT_ROW_BY).init(rowNames.toArray());
        this.getInputPanelBuilder().getInputParameter(DIVIDE_ROW_BY).init(rowNames.toArray());
        return true;
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        FloatListFunction c;
        Dataset dataset = (Dataset)map.get("dataset");
        ArrayList<FloatListFunction> adjustFunctions = new ArrayList<FloatListFunction>();
        boolean log2 = (Boolean)map.get(LOG2);
        boolean inverseLog2 = (Boolean)map.get(INVERSE_LOG2);
        String ceilingString = (String)map.get(CEILING);
        String floorString = (String)map.get(FLOOR);
        if (ceilingString != null && !"".equals(ceilingString)) {
            try {
                float ceiling = ParserHelper.parseFloat(ceilingString);
                c = new Ceiling();
                ((Ceiling)c).setCeiling(ceiling);
                adjustFunctions.add(c);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Ceiling is not a number.");
            }
        }
        if (floorString != null && !"".equals(floorString)) {
            try {
                float floor = ParserHelper.parseFloat(floorString);
                c = new Floor();
                ((Floor)c).setFloor(floor);
                adjustFunctions.add(c);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Floor is not a number.");
            }
        }
        if (log2) {
            adjustFunctions.add(new LogScale());
        } else if (inverseLog2) {
            adjustFunctions.add(new InverseLog2());
        }
        for (FloatListFunction adj : adjustFunctions) {
            DatasetRowView rowView = new DatasetRowView(dataset);
            int rows = dataset.getRowCount();
            for (int i = 0; i < rows; ++i) {
                rowView.setIndex(i);
                adj.evaluate(rowView);
            }
        }
        String divideColumnBy = (String)map.get(DIVIDE_COLUMN_BY);
        String substractColumnBy = (String)map.get(SUBTRACT_COLUMN_BY);
        String divideRowBy = (String)map.get(DIVIDE_ROW_BY);
        String substractRowBy = (String)map.get(SUBTRACT_ROW_BY);
        dataset = DatasetUtil.deepCopy(dataset);
        if (substractRowBy != null && !substractRowBy.equals("(None)")) {
            new AdjustDatasetOperation(DatasetUtil.transposeView(dataset), dataset.getRowMetadata().get(substractRowBy)){

                @Override
                public float operation(float value, float computed) {
                    return value - computed;
                }
            };
        }
        if (divideRowBy != null && !divideRowBy.equals("(None)")) {
            new AdjustDatasetOperation(DatasetUtil.transposeView(dataset), dataset.getRowMetadata().get(divideRowBy)){

                @Override
                public float operation(float value, float computed) {
                    return value / computed;
                }
            };
        }
        if (substractColumnBy != null && !substractColumnBy.equals("(None)")) {
            new AdjustDatasetOperation(dataset, dataset.getColumnMetadata().get(substractColumnBy)){

                @Override
                public float operation(float value, float computed) {
                    return value - computed;
                }
            };
        }
        if (divideColumnBy != null && !divideColumnBy.equals("(None)")) {
            new AdjustDatasetOperation(dataset, dataset.getColumnMetadata().get(divideColumnBy)){

                @Override
                public float operation(float value, float computed) {
                    return value / computed;
                }
            };
        }
        boolean performColumnRankNormalization = (Boolean)map.get(RANK_NORMALIZATION);
        boolean performQuantileNormalization = (Boolean)map.get(QUANTILE_NORMALIZATION);
        if (performQuantileNormalization) {
            QuantileNorm.qnorm(dataset);
        }
        if (performColumnRankNormalization) {
            Spearman.columnRankNormalize(((RowMajorArray2DDataset)dataset).getArray());
        }
        DefaultProject p = new DefaultProject(dataset, (Project)map.get("project"));
        return new ProjectGENEEResultTreeNode(p, this.getHistory(map));
    }
}

