/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function;

import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class NumberAbsValueGreaterOrEqualTo
implements FloatListFunction {
    private float value;

    @Override
    public float evaluate(FloatList list) {
        int count = 0;
        int length = list.size();
        for (int j = 0; j < length; ++j) {
            float d = list.getValue(j);
            if (!(Math.abs(d) >= this.value)) continue;
            ++count;
        }
        return count;
    }

    public String getDescription() {
        return "Counts the number of absolute values greater than or equal to Y.";
    }

    public float getParameterValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value = Math.abs(value);
    }
}

