/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function;

import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.matrix.FloatList;

public class StandardDeviation
implements FloatListFunction {
    private float mean;

    @Override
    public float evaluate(FloatList list) {
        this.mean = Mean.mean(list);
        return FloatListStatUtils.stdev(list, this.mean);
    }

    public float evaluate(FloatList list, float mean) {
        this.mean = mean;
        return FloatListStatUtils.stdev(list, mean);
    }

    public float getMean() {
        return this.mean;
    }

    public static float thresholdStandardDeviation(float mean, float standardDeviation, float percent) {
        float returnValue = standardDeviation;
        float absMean = Math.abs(mean);
        float minStdev = percent * absMean;
        if (minStdev > standardDeviation) {
            returnValue = minStdev;
        }
        if (returnValue < percent) {
            returnValue = percent;
        }
        return returnValue;
    }
}

