/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function;

import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class WeightedMean
implements FloatListFunction {
    private FloatList weights;

    @Override
    public float evaluate(FloatList list) {
        return WeightedMean.mean(list, this.weights);
    }

    public void setWeights(FloatList weights) {
        this.weights = weights;
    }

    public String toString() {
        return "Weighted Mean";
    }

    public static float mean(FloatList values, FloatList weights) {
        float numerator = 0.0f;
        float denom = 0.0f;
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            float value = values.getValue(i);
            if (Float.isNaN(value)) continue;
            float weight = weights.getValue(i);
            numerator += weight * value;
            denom += weight;
        }
        return denom == 0.0f ? Float.NaN : numerator / denom;
    }
}

