/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class FisherExactTest
implements BivariateFloatListFunction {
    private int side = 2;

    @Override
    public float evaluate(FloatList listOne, FloatList listTwo) {
        int aHit = 0;
        int aMiss = 0;
        int size = listOne.size();
        for (int j = 0; j < size; ++j) {
            float val = listOne.getValue(j);
            if (Float.isNaN(val)) continue;
            if (val > 0.0f) {
                ++aHit;
                continue;
            }
            ++aMiss;
        }
        int bHit = 0;
        int bMiss = 0;
        int size2 = listTwo.size();
        for (int j = 0; j < size2; ++j) {
            float val = listTwo.getValue(j);
            if (Float.isNaN(val)) continue;
            if (val > 0.0f) {
                ++bHit;
                continue;
            }
            ++bMiss;
        }
        int populationSize = aHit + aMiss + bHit + bMiss;
        int numberOfSuccesses = aHit + bHit;
        int x = aHit;
        int sampleSize = aHit + aMiss;
        HypergeometricDistribution dist = new HypergeometricDistribution(populationSize, numberOfSuccesses, sampleSize);
        if (this.side == 2) {
            float gt = (float)dist.upperCumulativeProbability(x);
            float lt = (float)dist.cumulativeProbability(x);
            return Math.min(1.0f, 2.0f * Math.min(gt, lt));
        }
        if (this.side == 0) {
            return (float)dist.upperCumulativeProbability(x);
        }
        return (float)dist.cumulativeProbability(x);
    }

    public void setSide(int side) {
        this.side = side;
    }

    public String toString() {
        return "Fisher Exact Test";
    }
}

